<?php $__env->startSection('title','Train/Tour Booking Enquiry'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-envelope me-2"></i>Train/Tour Booking Enquiry
                </h1>
            </div>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.enquiries.packages')); ?>">
                        <i class="fas fa-map-marked-alt me-1"></i>Tour
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.enquiries.cars')); ?>">
                        <i class="fas fa-taxi me-1"></i>Car
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo e(route('admin.enquiries.trains')); ?>">
                        <i class="fas fa-train me-1"></i>Train
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.enquiries.hotels')); ?>">
                        <i class="fas fa-bed me-1"></i>Hotel
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.enquiries.customized')); ?>">
                        <i class="fas fa-map-marked-alt me-1"></i>Customized Tour
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.enquiries.plan.trip')); ?>">
                        <i class="fas fa-globe me-1"></i>Plan Trip
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.enquiries.general')); ?>">
                        <i class="fas fa-list me-1"></i>Custom/Genneral Enquiries
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Train/Tour</th>
                                    <th>Customer Name</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $enquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if($enquiry->train_id != null && $enquiry->train): ?>
                                            <strong class="text-primary train-details" data-id="<?php echo e($enquiry->train->id); ?>">
                                                <?php echo e($enquiry->train->title ?? 'N/A'); ?>

                                            </strong>
                                        <?php elseif($enquiry->train_tour_id != null && $enquiry->tour): ?>
                                            <strong class="text-primary tour-details" data-id="<?php echo e($enquiry->tour->id); ?>">
                                                <?php echo e($enquiry->tour->title ?? 'N/A'); ?>

                                            </strong>
                                        <?php else: ?>
                                            <strong>N/A</strong>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong class="text-primary"><?php echo e($enquiry->name); ?></strong>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block"><?php echo e($enquiry->email); ?></small>
                                            <small class="text-muted"><?php echo e($enquiry->phone); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($enquiry->is_confirmed == 0): ?>
                                            <span class="badge bg-warning">New</span>
                                        <?php elseif($enquiry->is_confirmed == 1): ?>
                                            <span class="badge bg-success">Confirmed</span>
                                        <?php elseif($enquiry->is_confirmed == 2): ?>
                                            <span class="badge bg-info">Proceeded</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary get-enquiry" data-url="<?php echo e(route('admin.enquiries.train.detail',$enquiry->id)); ?>" data-upurl="<?php echo e(route('admin.enquiries.train.status',$enquiry->id)); ?>">
                                            <i class="fas fa-eye icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <?php if($enquiry->is_confirmed != 1): ?>
                                        <button class="btn btn-sm btn-outline-success update-enquiry" data-url="<?php echo e(route('admin.enquiries.train.status',$enquiry->id)); ?>">
                                            <i class="fas fa-check icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <?php endif; ?>
                                        <button class="btn btn-sm btn-outline-danger delete-enquiry" data-url="<?php echo e(route('admin.enquiries.train.delete',$enquiry->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $__env->make('admin.common.pagination', ['paginator' => $enquiries], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="viewInquiryModal1" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {

    // ================== VIEW ENQUIRY ==================
    $(document).on("click", ".get-enquiry", function () {
        let btn = $(this);
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');

        let url = $(this).data("url");
        let upurl = $(this).data("upurl");

        $.get(url, function (res) {
            if (res.success) {
                let data = res.data;

                // populate modal
                let modal = $("#viewInquiryModal1");
                if(data.train_id)
                    modal.find(".modal-title").text("Enquiry #" + data.train.title);
                else
                    modal.find(".modal-title").text("Enquiry #" + data.tour.title);
                modal.find(".modal-body").html(`
                    <h6 class="fw-bold">Customer Information</h6>
                    <p><strong>Name:</strong> ${data.name}</p>
                    <p><strong>Email:</strong> ${data.email}</p>
                    <p><strong>Phone:</strong> ${data.phone}</p>
                    <p><strong>Status:</strong> 
                        ${(() => {
                            switch (data.is_confirmed) {
                                case 0:
                                    return '<span class="badge bg-warning">New</span>';
                                case 2:
                                    return '<span class="badge bg-info">Processed</span>';
                                case 1:
                                    return '<span class="badge bg-success">Confirmed</span>';
                                default:
                                    return '<span class="badge bg-secondary">Unknown</span>';
                            }
                        })()}
                    </p>
                    <h6 class="fw-bold mt-3">Enquiry Details</h6>
                    <p class="text-muted">${data.message ?? ''}</p>
                `);
                let html = '';
                if(data.is_confirmed == 2){
                    html += `<button type="button" class="btn btn-success update-enquiry" data-url="${upurl}">Mark as Confirmed
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>`;
                } else if(data.is_confirmed == 0) {
                    html += `<button type="button" class="btn btn-primary" id="p-btn" data-url="${upurl}">Mark as Processed
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>`; 
                } else {
                    html+=`<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>`;
                }
                modal.find(".modal-footer").html(html);
                modal.modal("show");
            }
        }).fail(function () {
            Swal.fire("Error", "Failed to fetch enquiry details.", "error");
        }).always(function () {
            // This runs after success or failure
            btn.find('.spinner-border').addClass('d-none');
            btn.find('.icon').removeClass('d-none');
        });
    });

    // ================== UPDATE STATUS ==================
    $(document).on("click", ".update-enquiry", function () {
        let url = $(this).data("url");
        Swal.fire({
            title: "Mark as Confirmed?",
            icon: "question",
            showCancelButton: true,
            confirmButtonText: "Yes, Confirm",
            cancelButtonText: "Cancel",
        }).then((result) => {
            if (result.isConfirmed) {
                let btn = $(this);
                btn.find('.spinner-border').removeClass('d-none');
                btn.find('.icon').addClass('d-none');
                $.post(url, { _token: "<?php echo e(csrf_token()); ?>",status:1 }, function (res) {
                    if (res.success) {
                        Swal.fire("Updated!", "Enquiry status updated.", "success").then(() => {
                            location.reload();
                        });
                    }
                }).fail(function () {
                    Swal.fire("Error", "Failed to update status.", "error");
                }).always(function () {
                    // This runs after success or failure
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                });
            }
        });
    });

    $(document).on("click", "#p-btn", function () {
        let url = $(this).data("url");
        let btn = $(this);
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.post(url, { _token: "<?php echo e(csrf_token()); ?>",status:2 }, function (res) {
            if (res.success) {
                Swal.fire("Updated!", "Enquiry status updated.", "success").then(() => {
                    location.reload();
                });
            }
        }).fail(function () {
            Swal.fire("Error", "Failed to update status.", "error");
        }).always(function () {
            // This runs after success or failure
            btn.find('.spinner-border').addClass('d-none');
            btn.find('.icon').removeClass('d-none');
        });
    });

    // ================== DELETE ENQUIRY ==================
    $(document).on("click", ".delete-enquiry", function () {
        let url = $(this).data("url");
        Swal.fire({
            title: "Are you sure?",
            text: "This enquiry will be permanently deleted.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, Delete",
        }).then((result) => {
            if (result.isConfirmed) {
                let btn = $(this);
                btn.find('.spinner-border').removeClass('d-none');
                btn.find('.icon').addClass('d-none');
                $.ajax({
                    url: url,
                    type: "DELETE",
                    data: { _token: "<?php echo e(csrf_token()); ?>" },
                    success: function (res) {
                        if (res.success) {
                            Swal.fire("Deleted!", "Enquiry has been removed.", "success").then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Failed to delete enquiry.", "error");
                    },
                    complete: function () {
                        // Hide loader, show button text back
                        btn.find('.spinner-border').addClass('d-none');
                        btn.find('.icon').removeClass('d-none');
                    }
                });
            }
        });
    });

});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/cholantravels/backend/resources/views/admin/enquiries/trains.blade.php ENDPATH**/ ?>