<?php $__env->startSection('title',"Page Setting"); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-cog me-2"></i><?php echo e($page_details->title); ?> Page Settings
                </h1>
            </div>
        </div>
    </div>
     <!-- Action Buttons -->
    <?php if($page_details->id !=7): ?>
    <div class="row mb-4" >
        <div class="col-12">
            <button class="btn btn-warning" onclick="addDealPackage();">
                <i class="fas fa-plus me-2"></i>Add Deal Package
            </button>
        </div>
    </div>
    <?php endif; ?>
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e(session('active_tab', $page_details->slug) == $page_details->slug ? 'active' : ''); ?>" data-tab="<?php echo e($page_details->slug); ?>_tab">

                        <i class="fas fa-cog me-1"></i><?php echo e($page_details->title); ?> Page Info
                    </a>
                </li>
                <?php if($page_details->id !=7): ?>
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'dpackage') ? 'active' :''); ?>" data-tab="dpackage_tab">
                        <i class="fas fa-box me-1"></i>Deal Packages
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
    
    <div class="row tab_details 
    <?php echo e(session('active_tab', $page_details->slug) != $page_details->slug ? 'd-none' : ''); ?>"  id="<?php echo e($page_details->slug); ?>_tab">

        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-cog me-2"></i>Page Details
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <strong><?php echo e($page_details->title); ?></strong>
                                    </td>
                                    <td>
                                        <?php echo \Illuminate\Support\Str::words($page_details->description, 10, '...'); ?>


                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="<?php echo e(storage_link($page_details->banner_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editPageModal">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <?php if($page_details->id !=7): ?>
                                        <button class="btn btn-sm btn-outline-primary page-faqs" data-id="<?php echo e($page_details->id); ?>"  data-url="<?php echo e(route('admin.page.faqUpdate',$page_details->id)); ?>">
                                            <i class="fa fa-question-circle icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <?php endif; ?>
                                        <button class="btn btn-sm btn-outline-primary page-meta" data-id="<?php echo e($page_details->id); ?>" data-url="<?php echo e(route('admin.page-meta.show.meta',$page_details->id)); ?>">
                                            <i class="fas fa-globe icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if($page_details->id !=7): ?>
    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') == 'dpackage') ? '' :'d-none'); ?>" id="dpackage_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-box me-2"></i>Deal Packages
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Package</th>
                                    <th>Title</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $deal_packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block"><?php echo e($b->package->title); ?> <?php echo e($b->package->details->duration_days.' D/'.$b->package->details->duration_nights.' N'); ?></strong>
                                        <small class="text-muted"><?php echo e($b->package->category->name); ?> (<?php echo e($b->package->source_location->name.', '.$b->package->source_location->country->name.' -> '.$b->package->location->name.', '.$b->package->location->country->name); ?>)</small>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block"><?php echo e($b->title); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="<?php echo e(storage_link($b->package->primary_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <input id="status_<?php echo e($b->package->id); ?>" type="checkbox" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.dpackage.update',$b->id)); ?>" class="js-switch dpackage-status" <?php echo $b->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary edit-dpackage" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.dpackage.edit',$b->id)); ?>">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-dpackage" data-id="<?php echo e($b->id); ?>" data-url="<?php echo e(route('admin.dpackage.destroy',$b->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
<?php if($page_details->id !=7): ?>
<div class="modal fade" id="addDealPackageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i><span id="modal-header-text">Add New Deal Package</span>
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="addBanner" method="POST" action="<?php echo e(route('admin.dpackage.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <div class="modal-body">
                    <input type="hidden" name="page_id" value="<?php echo e($page_details->id); ?>">
                    <div class="mb-3">
                        <label for="banner_package_id" class="form-label">Select Package</label>
                        <select class="form-select" id="banner_package_id" name="package_id" required>
                            <option value="">Choose a package...</option>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($p->id); ?>"><?php echo e($p->title); ?>(<?php echo e($p->details->duration_days.' D/'.$p->details->duration_nights.' N'); ?>)(<?php echo e($p->category->name); ?>)(<?php echo e($p->source_location->name.', '.$p->source_location->country->name.' -> '.$p->location->name.', '.$p->location->country->name); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="text-danger d-none" id="deal-package-id-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-save me-2"></i>Save
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editDealPackageModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Package
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editDealPackage" method="POST" action="" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_dPackage_package_id" class="form-label">Select Package</label>
                        <select class="form-select" id="edit_dPackage_package_id" name="package_id" required>
                            <option value="">Choose a package...</option>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($p->id); ?>"><?php echo e($p->title); ?>(<?php echo e($p->details->duration_days.' D/'.$p->details->duration_nights.' N'); ?>)(<?php echo e($p->category->name); ?>)(<?php echo e($p->source_location->name.', '.$p->source_location->country->name.' -> '.$p->location->name.', '.$p->location->country->name); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-save me-2"></i>Save
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="modal fade" id="editPageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit <?php echo e($page_details->title); ?> Page
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editPage" method="POST" action="<?php echo e(route('admin.page.update',$page_details->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_page_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_page_title" name="title" value="<?php echo e(old('title',$page_details->title)); ?>" required>
                    </div>
                    <div class="row" id="praimaryPreview">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-banner-image" src="<?php echo e(storage_link($page_details->banner_image)); ?>" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text" class="form-control mb-2" id="edit_banner_image_alt" name="banner_image_alt" required placeholder="Banner Image Alt Text" value="<?php echo e(old('banner_image_alt',$page_details->banner_image_alt)); ?>">
                        <div class="text-danger d-none" id="edit-banner-image-alt-error"></div>

                        <label for="edit_banner_image" class="form-label">Image</label>
                        <input type="file" class="form-control " id="edit_banner_image" name="banner_image" accept=".webp,image/webp" <?php echo e(!$page_details->banner_image ? 'required' : ''); ?>>
                        <div class="text-danger d-none" id="edit-banner-image-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control tinymce" 
                        id="description" name="description" rows="5">
                            <?php echo e(old('description',$page_details->description)); ?>

                        </textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="submit-btn">
                        <i class="fas fa-save me-2"></i>Update Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="faqModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="city-title"><?php echo e($page_details->title); ?> Page Faqs</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="faqForm" method="POST" action="" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> 
            <?php echo method_field('PUT'); ?>
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-setting-btn" data-url="">
                        <i class="fas fa-save me-2"></i>Save Faqs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="pageMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="page-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="pageMeta" method="POST" action="<?php echo e(route('admin.page.update',$page_details->id)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> 
            <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="page-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="page-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="page_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="page_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="page-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    let faqIndex = 0;
    function activeTab(ele){
        // Remove active from all nav links
        let nav = document.querySelectorAll('.tab_link');
        nav.forEach(function(element) {
            element.classList.remove('active');
            if (element.getAttribute('data-tab') === ele) {
                element.classList.add('active');
            }
        });

        // Hide all tabs
        let tab = document.querySelectorAll('.tab_details');
        tab.forEach(function(element) {
            element.classList.add('d-none');
        });

        let selectTab = document.getElementById(ele);
        if (selectTab) {
            selectTab.classList.remove('d-none');
        }
    }

    function addDealPackage() {
        activeTab('dpackage_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }
        let dealModal = new bootstrap.Modal(document.getElementById('addDealPackageModal'));
        dealModal.show();
    }


    $(document).ready(function () {
        <?php if(session('success')): ?>
            toastr.success("<?php echo e(session('success')); ?> ", 'Success');
        <?php endif; ?>

        $(document).on('click', '.tab_link', function() {
            $('.tab_link').removeClass('active');
            $(this).addClass('active');
            $('.tab_details').addClass('d-none');
            let ele = $(this).data('tab');
            $('#'+ele).removeClass('d-none');
        });

        
        $(document).on('change', '.dpackage-status', function() {
            let checkbox = $(this);
            let package_status = checkbox.prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': package_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: data.status,
                        title: data.status,
                        text: data.message
                    })
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    checkbox.prop('checked', !package_status);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        $(document).on('click', '.edit-dpackage', function () {
            let dealModal = new bootstrap.Modal(document.getElementById('addDealPackageModal'));
            dealModal.show();
        });

        $(document).on("click", ".delete-dpackage", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Banner not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });

        document.getElementById('editPage').addEventListener('submit', function(event) {
        tinymce.triggerSave();
        event.preventDefault(); 
        $('.invalid-feedback').addClass('d-none');
        $('#submit-btn').prop('disabled',true);
        let isError = 0;
        let description = document.getElementById('description');
        if(!description.value.trim()) {
            $('.invalid-feedback').removeClass('d-none');
            $('.invalid-feedback').addClass('d-block');
            $('.invalid-feedback').text('Descriptions required');
            $('#submit-btn').prop('disabled',false);
        } else {
            this.submit();
        }

    });

    
    /* ==== Primary Image Preview ==== */
    document.getElementById('edit_banner_image').addEventListener('change', function(event) {
        let file = event.target.files[0];
        let preview = document.getElementById('praimaryPreview');
        preview.innerHTML = ""; // Clear old preview

        if (file && file.type.startsWith('image/')) {
            let reader = new FileReader();
            reader.onload = function(e) {
                let col = document.createElement('div');
                col.classList.add('col-md-12', 'mb-3');
                col.innerHTML = `
                    <div class="card">
                        <img src="${e.target.result}" class="card-img-top img-fluid" 
                            style="height:150px; object-fit:cover;">
                    </div>
                `;
                preview.appendChild(col);
            };
            reader.readAsDataURL(file);
        }
    });

    $(document).on('click', '.page-faqs', function() {
        let btn = $(this);
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        let id = btn.data('id');
        let dataUrl = btn.data('url');
        
        $('#faqForm').attr('action',dataUrl);
        $.ajax({
            type: "GET",
            dataType: "json",
            url: "<?php echo e(route('admin.page.faq')); ?>", // better to point this to a dedicated faq route
            data: { id: id },
            success: function(data) {
                let faqs = data.faqs || [];
                let body = `
                <table class="table" id="faqTable">
                    <thead>
                        <tr>
                            <th>Question</th>
                            <th>Answer</th>
                            <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                        </tr>
                    </thead>
                    <tbody>
                `;

                if (faqs.length > 0) {
                    $.each(faqs, function(index, faq) {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                            </tr>
                        `;
                        faqIndex++;
                    });
                } else {
                    body += `
                        <tr class="b-none">
                            <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                            <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                            <td></td>
                        </tr>
                    `;
                    faqIndex++;
                }

                body += `</tbody></table>`;

                $('#faqModal .modal-body').html(body);

                // open modal
                $('#faqModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching package FAQs.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });

    $(document).on('click', '#addFaqRow', function() {
        let row = `
            <tr class="b-none">
                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required /></td>
                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
            </tr>`;
        faqIndex++;
        $('#faqTable tbody').append(row);
        
    });

    $(document).on('click', '.removeFaqRow', function() {
        $(this).closest('tr').remove();
    });


    $(document).on('click', '.page-meta', function() {
        let btn = $(this);
        let id = $(this).data('id');
        let dataUrl = $(this).data('url').trim();
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: dataUrl,
            success: function(data) {
                $('#page-title').text('# '+data.title+'-Meta Info');
                if(data.meta != null){
                    $('#page_meta_title').val(data.meta.meta_title);
                    $('#page_meta_description').val(data.meta.meta_description);
                    $('#page_meta_keywords').val(data.meta.meta_keywords);
                    $('#page_h1_heading').val(data.meta.h1_heading);
                    $('#page_meta_details').val(data.meta.meta_details);
                }
                $('#pageMetaModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching city details.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/cholantravels/backend/resources/views/admin/settings/page.blade.php ENDPATH**/ ?>