@extends('master.authMaster')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Basic Layout & Basic with Icons -->
            <div class="row mb-6 gy-6">
                <!-- Basic Layout -->
                <div class="col-xxl">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">ADD USER</h5>
                            <small class="text-body-secondary float-end">user entry</small>
                        </div>
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        <div class="card-body">
                            <form method="POST" action="{{ route('employee.add.submit') }}">
                                @csrf

                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-name">Name
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="basic-default-name"
                                            placeholder="John Doe" name="name" value="{{ old('name') }}" />
                                        @error('name')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-company">Employee
                                        Code<span class="text-danger">*</span></label>
                                    <div class="col-sm-10">
                                        <input type="text" name="employee_code" value="{{ old('employee_code') }}"
                                            class="form-control" id="basic-default-company" placeholder=" ex. MBSW**** " />
                                        @error('employee_code')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label class="col-sm-2 col-form-label" for="employee-role">Role
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <select id="employee-role" name="role_id"
                                            class="form-select  @error('role_id') is-invalid @enderror">
                                            <option value="">-- Select Role --</option>
                                            <option value="1"{{ old('role_id') == 1 ? 'selected' : '' }}>Admin
                                            </option>
                                            <option value="2"{{ old('role_id') == 2 ? 'selected' : '' }}>Manager
                                            </option>
                                            <option value="3"{{ old('role_id') == 3 ? 'selected' : '' }}>Resource
                                            </option>
                                            <option value="4"{{ old('role_id') == 4 ? 'selected' : '' }}>Team Lead
                                            </option>
                                        </select>
                                        @error('role_id')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                {{-- <div class="row mb-4">
                                    <label class="col-sm-2 col-form-label" for="employee-department">Department
                                    </label>
                                    <div class="col-sm-10">
                                        <select id="employee-department" name="department_id"
                                            class="form-select @error('department_id') is-invalid @enderror">
                                            <option value="">-- Select Department --</option>
                                            <option value="1" {{ old('department_id') == 1 ? 'selected' : '' }}>
                                                IT-frontend</option>
                                            <option value="2" {{ old('department_id') == 2 ? 'selected' : '' }}>
                                                IT-backend</option>
                                            <option value="3" {{ old('department_id') == 3 ? 'selected' : '' }}>
                                                IT-Software Developer</option>
                                            <option value="4" {{ old('department_id') == 4 ? 'selected' : '' }}>
                                                IT-Application Developer</option>
                                            <option value="5" {{ old('department_id') == 5 ? 'selected' : '' }}>
                                                Sales
                                            </option>
                                            <option value="6" {{ old('department_id') == 6 ? 'selected' : '' }}>
                                                Accounts</option>
                                            <option value="7" {{ old('department_id') == 7 ? 'selected' : '' }}>
                                                Manager</option>
                                        </select>
                                        @error('department_id')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-email">Email
                                       
                                    </label>
                                    <div class="col-sm-10">
                                        <div class="input-group input-group-merge">
                                            <input type="text" name="email" id="basic-default-email"
                                                class="form-control" value="{{ old('email') }}" placeholder="john.doe"
                                                aria-label="john.doe" aria-describedby="basic-default-email2" />
                                            @error('email')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                            <span class="input-group-text" id="basic-default-email2">@example.com</span>
                                        </div>
                                        <div class="form-text">You can use letters, numbers & periods</div>
                                    </div>
                                </div>
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No
                                       
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" name="phone" value="{{ old('phone') }}"
                                            id="basic-default-phone" class="form-control phone-mask"
                                            placeholder="658 799 8941" aria-label="658 799 8941"
                                            aria-describedby="basic-default-phone" />
                                        @error('phone')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                {{-- Reporting To --}}
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="reporting_to">Reporting To
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <select id="reporting_to" name="reporting_to[]" multiple
                                            class="form-select select2 @error('reporting_to') is-invalid @enderror">
                                            @foreach ($users as $user)
                                                @if ($user->role_id == 2 || $user->role_id == 4)
                                                    <option value="{{ $user->id }}" data-name="{{ $user->name }}"
                                                        data-rate="{{ $user->employee->monthly_rate ?? 0 }}"
                                                        {{ in_array($user->id, old('reporting_to', [])) ? 'selected' : '' }}>
                                                        {{ $user->name }}
                                                    </option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @error('reporting_to')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                {{-- <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="employee-skills">Skills
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <select id="employee-skills" name="skills[]" multiple
                                            class="form-select select2 @error('skills') is-invalid @enderror">
                                            <option value="PHP"
                                                {{ in_array('PHP', old('skills', [])) ? 'selected' : '' }}>PHP</option>
                                            <option value="Laravel"
                                                {{ in_array('Laravel', old('skills', [])) ? 'selected' : '' }}>Laravel
                                            </option>
                                            <option value="JavaScript"
                                                {{ in_array('JavaScript', old('skills', [])) ? 'selected' : '' }}>
                                                JavaScript</option>
                                            <option value="VueJS"
                                                {{ in_array('VueJS', old('skills', [])) ? 'selected' : '' }}>VueJS
                                            </option>
                                            <option value="React"
                                                {{ in_array('React', old('skills', [])) ? 'selected' : '' }}>React
                                            </option>
                                            <option value="MySQL"
                                                {{ in_array('MySQL', old('skills', [])) ? 'selected' : '' }}>MySQL
                                            </option>
                                        </select>
                                        @error('skills')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}
                                {{-- <div class="row mb-6" id="monthly_rate">
                                    <label class="col-sm-2 col-form-label" for="basic-default-name">Monthly Rate
                                        (INR)<span class="text-danger">*</span></label>
                                    <div class="col-sm-10">
                                        <input type="number" name="monthly_rate" value="{{ old('monthly_rate') }}"
                                            class="form-control" id="basic-default-name" placeholder="Rate per Month" />
                                        @error('monthly_rate')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}
                                {{-- Hourly Rate in INR / USD --}}
                                {{-- <div class="row mb-6" style="display: none;" id="hourly_rate">
                                    <label class="col-sm-2 col-form-label">Hourly Rate (INR) <span
                                            class="text-danger">*</span></label>
                                    <div class="col-sm-4">
                                        <input type="number" name="hourly_rateINR" value="{{ old('hourly_rateINR') }}"
                                            class="form-control" id="basic-default-name"
                                            placeholder="Rate per hour in INR" step="0.01" readonly />
                                        @error('hourly_rateINR')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <label class="col-sm-2 col-form-label">Hourly Rate (USD) <span
                                            class="text-danger">*</span></label>
                                    <div class="col-sm-4">
                                        <input type="number" name="hourly_rateUSD" class="form-control"
                                            placeholder="Rate per hour in USD" value="{{ old('hourly_rateUSD') }}"
                                            step="0.01" readonly>
                                        @error('hourly_rateUSD')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}
                                {{-- <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-name">Experience
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="number" class="form-control" name="experience"
                                            value="{{ old('experience') }}" id="basic-default-name"
                                            placeholder="Experience in months" />
                                        @error('experience')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}
                                {{-- <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-company">Password
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" name="password" value="{{ old('password') }}"
                                            class="form-control" id="basic-default-company"
                                            placeholder=" Set a passowrd for the employee">
                                        @error('password')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div> --}}
                                <div class="row justify-content-end">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-primary">Add User</button>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->
    @endsection
    @section('scripts')
        <script>
            $(document).ready(function() {
                $('#reporting_to').select2({
                    placeholder: "Select Team Lead / Project Manager",
                    allowClear: true,
                    width: '100%'
                });
                // $('#employee-skills').select2({
                //     placeholder: "Select Skills",
                //     allowClear: true,
                //     width: '100%'
                // });

                // $("#monthly_rate input").on('input', function() {
                //     const monthlyRate = parseFloat($(this).val());

                //     if (!isNaN(monthlyRate)) {
                //         $('#hourly_rate').slideDown();
                //         const hourlyINR = ((monthlyRate / 30) / 8).toFixed(2);
                //         const hourlyUSD = (hourlyINR / 85.80).toFixed(2);
                //         $('input[name="hourly_rateINR"]').val(hourlyINR);
                //         $('input[name="hourly_rateUSD"]').val(hourlyUSD);

                //         console.log("Hourly INR: ", hourlyINR, "Hourly USD: ", hourlyUSD);
                //     } else {
                //         $('#hourly_rate').slideUp();
                //         $('input[name="hourly_rateINR"]').val('');
                //         $('input[name="hourly_rateUSD"]').val('');
                //     }
                // });

            });
        </script>
    @endsection
