@extends('master.authMaster')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Basic Layout & Basic with Icons -->
            <div class="row mb-6 gy-6">
                <!-- Basic Layout -->
                <div class="col-xxl">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">EDIT USER</h5>
                            <small class="text-body-secondary float-end">user</small>
                        </div>
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        <div class="card-body">
                            <form method="POST" action=" {{ route('employees.edit.submit', $employee->id) }}">
                                @csrf
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-name">Name
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="basic-default-name"
                                            placeholder="John Doe" name="name" value="{{ $employee->name }}" />
                                        @error('name')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <?php
                                print_r($employee->id);
                                print_r($employee->name); ?>
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-company">Employee Code</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="employee_code" value="{{ $employee->employee_code }}"
                                            class="form-control" id="basic-default-company" placeholder=" ex. MBSW**** " />
                                        @error('employee_code')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label class="col-sm-2 col-form-label" for="employee-role">Role
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        <select id="employee-role" name="role_id"
                                            class="form-select  @error('role_id') is-invalid @enderror">
                                            <option value="">-- Select Role --</option>
                                            <option value="1"{{ $employee->role_id == 1 ? 'selected' : '' }}>
                                                Admin</option>
                                            <option value="2"{{ $employee->role_id == 2 ? 'selected' : '' }}>
                                                Manager
                                            </option>
                                            <option value="3"{{ $employee->role_id == 3 ? 'selected' : '' }}>
                                                resource
                                            </option>
                                            <option value="4"{{ $employee->role_id == 4 ? 'selected' : '' }}>HR
                                            </option>
                                        </select>
                                        @error('role_id')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-email">Email
                                    </label>
                                    <div class="col-sm-10">
                                        <div class="input-group input-group-merge">
                                            <input type="text" name="email" id="basic-default-email"
                                                class="form-control" value="{{ $employee->email }}" placeholder="john.doe"
                                                aria-label="john.doe" aria-describedby="basic-default-email2" disabled/>
                                            @error('email')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                            <span class="input-group-text" id="basic-default-email2">@example.com</span>
                                        </div>
                                        <div class="form-text">You can use letters, numbers & periods</div>
                                    </div>
                                </div>
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="basic-default-phone">Phone No
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" name="phone" value="{{ $employee->phone }}"
                                            id="basic-default-phone" class="form-control phone-mask"
                                            placeholder="658 799 8941" aria-label="658 799 8941"
                                            aria-describedby="basic-default-phone" />
                                        @error('phone')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                {{-- Reporting To --}}
                                <div class="row mb-6">
                                    <label class="col-sm-2 col-form-label" for="reporting_to">Reporting To
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="col-sm-10">
                                        @php
                                            $selectedSkills =
                                                old('reporting_to') ??
                                                json_decode($employee->reporting_to ?? '[]', true);
                                        @endphp

                                        <select id="reporting_to" name="reporting_to[]" multiple
                                            class="form-select select2 @error('reporting_to') is-invalid @enderror">
                                            @foreach ($users as $user)
                                                @if ($user->role_id == 2 || $user->role_id == 4)
                                                    <option value="{{ $user->id }}" data-name="{{ $user->name }}"
                                                        {{ in_array($user->id, $selectedSkills) ? 'selected' : '' }}>
                                                        {{ $user->name }}
                                                    </option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @error('reporting_to')
                                            <div class="text-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row justify-content-end">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-primary">Save User</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->
    @endsection
    @section('scripts')
        <script>
            $(document).ready(function() {
                $('#reporting_to').select2({
                    placeholder: "Select Team Lead / Project Manager",
                    allowClear: true,
                    width: '100%'
                });
                $("#monthly_rate input").on('input', function() {
                    const monthlyRate = parseFloat($(this).val());

                    if (!isNaN(monthlyRate)) {
                        $('#hourly_rate').slideDown();
                        const hourlyINR = ((monthlyRate / 30) / 8).toFixed(2);
                        const hourlyUSD = (hourlyINR / 85.80).toFixed(2);
                        $('input[name="hourly_rateINR"]').val(hourlyINR);
                        $('input[name="hourly_rateUSD"]').val(hourlyUSD);

                        console.log("Hourly INR: ", hourlyINR, "Hourly USD: ", hourlyUSD);
                    } else {
                        $('#hourly_rate').slideUp();
                        $('input[name="hourly_rateINR"]').val('');
                        $('input[name="hourly_rateUSD"]').val('');
                    }
                });
            });
        </script>
    @endsection
