<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClassFeeConfig extends Model
{
    protected $table = 'class_fees_config';
    protected $fillable = ['class_id','fee_head_id','financial_year_id','due_date','due_day_of_month','fee_type','amount','late_fee_amount','status'];

    public function feeHead()
    {
        return $this->belongsTo(FeeHead::class, 'fee_head_id');
    }

    public function class()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }
    

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }
}
