<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\AcademicYear;

class SchoolClass extends Model
{
    protected $table = 'classes';

    protected $fillable = [
        'school_id',
        'class_name',
        'status'
    ];

    public function sections()
    {
        return $this->hasMany(SchoolSection::class, 'class_id');
    }

    public function studentClassDetails()
    {
        return $this->hasMany(StudentClassDetail::class, 'class_id');
    }

    // ✅ ACTIVE + CURRENT ACADEMIC YEAR STUDENTS
    public function students()
    {
        $currentYear = AcademicYear::current();

        return $this->hasManyThrough(
            Student::class,
            StudentClassDetail::class,
            'class_id',        // FK on student_class_details
            'id',              // PK on students
            'id',              // PK on classes
            'student_id'       // FK on student_class_details
        )
        ->where('student_class_details.status', 1)
        ->when($currentYear, function ($q) use ($currentYear) {
            $q->where('student_class_details.financial_year_id', $currentYear->id);
        })
        ->where('students.status', 1);
    }
}
