<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Staff extends Model
{

    protected $table = 'staffs';
    protected $fillable = ['name','phone','email','category','designation','qualification','address','photo','join_date','status'];

    public function bankDetails()
    {
        return $this->hasOne(StaffBankDetails::class,'staff_id');
    }

    public function salary()
    {
        return $this->hasOne(StaffSalary::class);
    }

    public function activeSalary($academicYearId)
    {
        return $this->hasOne(StaffSalary::class)
            ->where('financial_year_id', $academicYearId)
            ->where('status', 1);
    }

    public function monthlySalaries()
    {
        return $this->hasMany(StaffMonthlySalary::class);
    }

    public function academicYears()
    {
        return $this->hasMany(StaffAcademicYear::class);
    }

    public function activeYear()
    {
        $activeAcademicYearId = AcademicYear::where('status', 1)->value('id');

        return $this->hasOne(StaffAcademicYear::class)
            ->where('financial_year_id', $activeAcademicYearId)
            ->where('status', 1);
    }

}
