<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StudentMonthlyFee extends Model
{
    protected $table = 'student_monthly_fees';
    protected $fillable = ['student_id','fee_for_month','financial_year_id','fee_head_id','amount','paid_date','late_fee','payment_method','transaction_id','late_fee'];

    public function student()
    {
        return $this->belongsTo(Student::class,'student_id');
    }

    public function feeHead()
    {
        return $this->belongsTo(FeeHead::class, 'fee_head_id');
    }
}
