<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Search</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('fees.index') }}">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">Select Class *</label>
                    <select name="class_id" class="form-select" required>
                        <option value="">Select Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}" {{ (request('class_id')==$class->id)?'selected':'' }}>
                                {{ $class->class_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Academic Year *</label>
                    <select name="financial_year_id" class="form-select" required>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}" {{ request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <!-- <div class="col-md-4">
                    <label class="form-label">Due Date</label>
                    <input type="date" name="due_date" class="form-control" value="{{ request('due_date') }}">
                </div> -->
            </div>
            <button type="submit" class="btn btn-primary">Load Configuration</button>
        </form>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Calss Fee Heads List</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>Fee Head Name</th>
                        <th>Amount</th>
                        <th>Fee Type</th>
                        <th>Due Day/Date</th>
                        <th>Late Fee</th>
                        <th>Class</th>
                        <th>Academic Year</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($classFees as $fee)
                    <tr
                        data-id="{{ $fee->id }}"
                        data-class-id="{{ $fee->class_id }}"
                        data-fee-head-id="{{ $fee->fee_head_id }}"
                        data-financial-year-id="{{ $fee->financial_year_id }}"
                        data-amount="{{ $fee->amount }}"
                        data-late_fee_amount="{{ $fee->late_fee_amount }}"
                        data-fee-type="{{ $fee->fee_type }}"
                        data-due-day="{{ $fee->fee_type === 'recurring' ? $fee->due_day_of_month : '' }}"
                        data-due-date="{{ $fee->fee_type === 'one_time' ? $fee->due_date : '' }}"
                    >
                        <!-- Fee Head -->
                        <td>{{ $fee->feeHead->name }}</td>

                        <!-- Amount -->
                        <td>₹{{ number_format($fee->amount, 2) }}</td>

                        <!-- Type -->
                        <td>
                            <span class="badge {{ $fee->fee_type === 'recurring' ? 'bg-info' : 'bg-secondary' }}">
                                {{ ucfirst(str_replace('_', ' ', $fee->fee_type)) }}
                            </span>
                        </td>

                        <!-- Due -->
                        <td>
                            @if($fee->fee_type === 'recurring')
                                Day {{ $fee->due_day_of_month }}
                            @else
                                {{ \Carbon\Carbon::parse($fee->due_date)->format('d M Y') }}
                            @endif
                        </td>

                        <!-- late Fee -->
                        <td>{{ $fee->late_fee_amount  }}</td>

                        <!-- Class -->
                        <td>{{ $fee->class->class_name }}</td>

                        <!-- Academic Year -->
                        <td>{{ $fee->financialYear->label }}</td>

                        <!-- Status -->
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input fee-status"
                                    type="checkbox"
                                    data-id="{{ $fee->id }}"
                                    data-url="{{ route('fees.updateClassFee', $fee->id) }}"
                                    {{ $fee->status ? 'checked' : '' }}
                                >
                            </div>
                        </td>

                        <!-- Actions -->
                        <td>
                            <!-- Edit -->
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-primary editClassFeeBtn"
                                data-url="{{ route('fees.updateClassFee', $fee->id) }}"
                            >
                                Edit
                            </button>

                            <!-- Delete -->
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-danger deleteClassFeeBtn"
                                data-url="{{ route('fees.deleteClassFee', $fee->id) }}"
                            >
                                Delete
                            </button>
                        </td>
                    </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No fee head found for the current academic year and class
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-end mt-3">
            {{ $classFees->appends(['tab' => $tab])->links() }}
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Config Class Fee Head</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('fees.storeClassFee') }}">
            @csrf

            <div class="row mb-2">

                <!-- Fee Head -->
                <div class="col-md-2">
                    <select name="fee_head_id" class="form-select" required>
                        <option value="">Select Fee Head</option>
                        @foreach($feeHeads as $heads)
                            <option value="{{ $heads->id }}">{{ $heads->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Amount -->
                <div class="col-md-2">
                    <input type="number" name="amount" class="form-control" placeholder="Amount (₹)" required>
                </div>

                <!-- Fee Type -->
                <div class="col-md-2">
                    <select name="fee_type" class="form-select" id="fee_type" required>
                        <option value="recurring">Recurring</option>
                        <option value="one_time">One Time</option>
                    </select>
                </div>


                <!-- Financial Year -->
                <div class="col-md-2">
                    <select name="financial_year_id" class="form-select" required>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Class -->
                <div class="col-md-2">
                    <select name="class_id" class="form-select" required>
                        <option value="all">All Classes</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->class_name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Due Date -->
                <div class="col-md-2 d-none" id="due_date_wrapper">
                    <input type="date" name="due_date" class="form-control">
                </div>

                <div class="col-md-2" id="due_day_wrapper">
                    <select name="due_day_of_month" class="form-select">
                        <option value="">Due Day</option>
                        @for($i = 1; $i <= 31; $i++)
                            <option value="{{ $i }}">{{ $i }}</option>
                        @endfor
                    </select>
                </div>

            </div>
            <div class="row mb-2">
                <!-- Amount -->
                <div class="col-md-2">
                    <input type="number" name="late_fee_amount" class="form-control" placeholder="Late Fee (₹)">
                </div>
            </div>

            <button class="btn btn-primary">Add</button>
        </form>

    </div>
</div>
