@extends('layouts.app')

@section('title','School Setup')

@section('breadcrumb')
<li class="breadcrumb-item active">School Setup</li>
@endsection

@section('content')
    <div id="school-setup-page" class="page-content">

        <h1 class="mb-4">School Setup</h1>

        <div class="row">
            <div class="col-md-8">

                {{-- School Details --}}
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">School Details</h5>
                    </div>

                    <div class="card-body">
                        <form action="{{ route('school.save') }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">School Name *</label>
                                    <input type="text" name="name" class="form-control"
                                        value="{{ $school->name ?? '' }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Established Year *</label>
                                    <input type="number" name="established_year" class="form-control"
                                        value="{{ $school->established_year ?? '' }}" required>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label class="form-label">Address *</label>
                                    <input type="text" name="address" class="form-control"
                                        value="{{ $school->address ?? '' }}" required>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Phone *</label>
                                    <input type="tel" name="phone" class="form-control"
                                        value="{{ $school->phone ?? '' }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Email *</label>
                                    <input type="email" name="email" class="form-control"
                                        value="{{ $school->email ?? '' }}" required>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label class="form-label">School Logo</label>
                                    <input type="file" name="logo" class="form-control">
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Save School Details</button>
                        </form>
                    </div>
                </div>

                {{-- Academic Year  --}}
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Academic Year</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('year.add') }}" method="POST" class="mb-3">
                            @csrf

                            <label class="form-label">Add New Academic Year</label>

                            <div class="input-group mb-1">
                                <input type="date" name="year_from"
                                    value="{{ old('year_from') }}"
                                    class="form-control a_year_from @error('year_from') is-invalid @enderror"
                                    required>

                                <input type="date" name="year_to"
                                    value="{{ old('year_to') }}"
                                    class="form-control a_year_to @error('year_to') is-invalid @enderror"
                                    required>

                                <input type="text" name="label"
                                    value="{{ old('label') }}"
                                    placeholder="eg: 2025-2026"
                                    class="a_year_label form-control @error('label') is-invalid @enderror"
                                    readonly required>

                                <button class="btn btn-outline-secondary" type="submit">Add</button>
                            </div>

                            {{-- Validation Messages --}}
                            <div class="text-danger small">
                                @error('year_from') <div>{{ $message }}</div> @enderror
                                @error('year_to')   <div>{{ $message }}</div> @enderror
                                @error('label')     <div>The Academic Year has already been taken</div> @enderror
                            </div>
                        </form>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Academic Year From</th>
                                    <th>Academic Year From</th>
                                    <th>Academic Year</th>
                                    <th>Set As Current</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($academic_years as $year)
                                    <tr>
                                        <td>{{ $year->year_from }}</td>
                                        <td>{{ $year->year_to }}</td>
                                        <td>{{ $year->label }}</td>
                                        <td>
                                            <div class="form-check form-switch">
                                                <input
                                                    class="form-check-input year-status"
                                                    type="checkbox"
                                                    id="status_{{ $year->id }}"
                                                    data-id="{{ $year->id }}"
                                                    data-url="{{ route('year.update', $year->id) }}"
                                                    {{ $year->status ? 'checked' : '' }}
                                                >
                                            </div>
                                        </td>

                                        <td>
                                            <button class="btn btn-sm btn-outline-primary year-edit-btn"
                                                data-id="{{ $year->id }}"
                                                data-label="{{ $year->label }}"
                                                data-y_from="{{ $year->year_from }}"
                                                data-y_to="{{ $year->year_to }}"
                                                data-url="{{ route('year.update', $year->id) }}"
                                                title="Edit Academic Year">
                                                <i class="bi bi-pencil"></i>
                                            </button>

                                            <!-- <button class="btn btn-sm btn-outline-danger year-delete-btn"
                                                data-id="{{ $year->id }}"
                                                data-url="{{ route('year.delete', $year->id) }}"
                                                title="Delete Academic Year">
                                                <i class="bi bi-trash"></i>
                                            </button> -->
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                {{-- Session  --}}
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Session</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('session.add') }}" method="POST" class="mb-3">
                            @csrf

                            <label class="form-label">Add New Session</label>

                            <div class="input-group mb-1">
                                <input type="text" name="session_name"
                                    value="{{ old('session_name') }}"
                                    placeholder="eg: Morning"
                                    class="a_session form-control @error('session_name') is-invalid @enderror"
                                    required>

                                <button class="btn btn-outline-secondary" type="submit">Add</button>
                            </div>

                            {{-- Validation Messages --}}
                            <div class="text-danger small">
                                @error('session_name')     <div>The Sesssion has already been taken</div> @enderror
                            </div>
                        </form>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($sessions as $sec)
                                    <tr>
                                        <td>{{ $sec->name }}</td>
                                        <td>
                                            <div class="form-check form-switch">
                                                <input
                                                    class="form-check-input session-status"
                                                    type="checkbox"
                                                    id="status_{{ $sec->id }}"
                                                    data-id="{{ $sec->id }}"
                                                    data-url="{{ route('session.update', $sec->id) }}"
                                                    {{ $sec->status ? 'checked' : '' }}
                                                >
                                            </div>
                                        </td>

                                        <td>
                                            <button class="btn btn-sm btn-outline-primary session-edit-btn"
                                                data-id="{{ $sec->id }}"
                                                data-name="{{ $sec->name }}"
                                                data-url="{{ route('session.update', $sec->id) }}"
                                                title="Edit Session">
                                                <i class="bi bi-pencil"></i>
                                            </button>

                                            <!-- <button class="btn btn-sm btn-outline-danger session-delete-btn"
                                                data-id="{{ $sec->id }}"
                                                data-url="{{ route('session.delete', $sec->id) }}"
                                                title="Delete Session">
                                                <i class="bi bi-trash"></i>
                                            </button> -->
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection

@section('modal')

    <!-- Edit Academic Year Modal -->
    <div class="modal fade" id="editYearModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editYearForm" action="">
                    @csrf 
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Academic Year</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_year_id" name="id">
                        <div class="mb-3">
                            <label>Academic Year From</label>
                            <input type="date" id="edit_year_from" name="year_from" class="a_year_from form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Academic Year To</label>
                            <input type="date" id="edit_year_to" name="year_to" class="a_year_to form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Label</label>
                            <input type="text" id="edit_year_label" name="label" class="a_year_label form-control" readonly required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="updateYearBtn" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Academic Year Modal -->
    <div class="modal fade" id="editSessionModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editSessionForm" action="">
                    @csrf 
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Session</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_session_id" name="id">
                        <div class="mb-3">
                            <label>Name</label>
                            <input type="text" id="edit_session_name" name="session_name" class="a_session_name form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="updateSessionBtn" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>
        $(document).ready(function() {

            // OPEN MODAL AND LOAD DATA
            $('.year-edit-btn').on('click', function () {

                let id = $(this).data('id');
                let label = $(this).data('label');
                let y_from = $(this).data('y_from');
                let y_to = $(this).data('y_to');
                let url = $(this).data('url');

                // fill modal
                $('#edit_year_id').val(id);
                $('#edit_year_label').val(label);
                $('#edit_year_from').val(y_from);
                $('#edit_year_to').val(y_to);
                $('#editYearForm').attr('action',url);

                // open modal
                $('#editYearModal').modal('show');
            });



            // UPDATE FORM SUBMIT
            $('#editYearForm').on('submit', function (e) {
                e.preventDefault();

                let id = $('#edit_year_id').val();
                let url = $('#editYearForm').attr('action');

                let btn = $('#updateYearBtn');
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Updated!", 'Academic Year updated successfully', "success");
                        $('#editYearModal').modal('hide');
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (k, v) {
                                msg += v + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        btn.prop('disabled', false).html('Update');
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function () {

            $('.year-status').on('change', function () {

                let checkbox = $(this);
                let id = checkbox.data('id');
                let url = checkbox.data('url');
                let status = checkbox.is(':checked') ? 1 : 0;

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: status
                    },
                    success: function (res) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Updated',
                            text: 'Status updated successfully',
                            timer: 1200,
                            showConfirmButton: false
                        });
                        location.reload();
                    },
                    error: function (xhr) {
                        Swal.fire("Error!", xhr.responseJSON.message, "error");

                        // revert checkbox state
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });

            });

        });
    </script>

    <script>
        $(document).ready(function () {

            function updateAcademicYearLabel() {
                let fromDate = $('.a_year_from').val();
                let toDate   = $('.a_year_to').val();

                if (fromDate && toDate) {
                    let fromYear = new Date(fromDate).getFullYear();
                    let toYear   = new Date(toDate).getFullYear();

                    $('.a_year_label').val(fromYear + '-' + toYear);
                }
            }

            $('.a_year_from, .a_year_to').on('change', function () {
                updateAcademicYearLabel();
            });

        });
    </script>

    <script>
        $(document).ready(function() {

            // OPEN MODAL AND LOAD DATA
            $('.session-edit-btn').on('click', function () {

                let id = $(this).data('id');
                let name = $(this).data('name');
                let url = $(this).data('url');

                // fill modal
                $('#edit_session_id').val(id);
                $('#edit_session_name').val(name);
                $('#editSessionForm').attr('action',url);

                // open modal
                $('#editSessionModal').modal('show');
            });



            // UPDATE FORM SUBMIT
            $('#editSessionForm').on('submit', function (e) {
                e.preventDefault();

                let id = $('#edit_session_id').val();
                let url = $('#editSessionForm').attr('action');

                let btn = $('#updateSessionBtn');
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Updated!", 'Session updated successfully', "success");
                        $('#editSessionModal').modal('hide');
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (k, v) {
                                msg += v + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        btn.prop('disabled', false).html('Update');
                    }
                });
            });

            $('.session-status').on('change', function () {

                let checkbox = $(this);
                let id = checkbox.data('id');
                let url = checkbox.data('url');
                let status = checkbox.is(':checked') ? 1 : 0;

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: status
                    },
                    success: function (res) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Updated',
                            text: 'Status updated successfully',
                            timer: 1200,
                            showConfirmButton: false
                        });
                        location.reload();
                    },
                    error: function (xhr) {
                        Swal.fire("Error!", xhr.responseJSON.message, "error");

                        // revert checkbox state
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });

            });
        });
    </script>


@endsection
