@extends('layouts.app')

@section('title','Staff')

@section('breadcrumb')
<li class="breadcrumb-item active">Staff</li>
@endsection

@section('content')
<!-- Staff Management Page -->
    <div id="staff-page" class="page-content">
        <h1 class="mb-4">Staff Management</h1>
        <ul class="nav nav-tabs mb-4" role="tablist">
            <li class="nav-item" role="presentation">
                <button
                    class="nav-link {{ session('tab', 'list') == 'list' ? 'active' : '' }}"
                    id="staff-list-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#staff-list"
                    type="button"
                    role="tab">
                    Staff List
                </button>
            </li>

            <li class="nav-item" role="presentation">
                <button
                    class="nav-link {{ session('tab') == 'add_staff' ? 'active' : '' }}"
                    id="add-staff-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#add-staff"
                    type="button"
                    role="tab">
                    Add Staff
                </button>
            </li>

            <li class="nav-item" role="presentation">
                <button
                    class="nav-link {{ session('tab') == 'staff_salary' ? 'active' : '' }}"
                    id="salary-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#salary-management"
                    type="button"
                    role="tab">
                    Salary Management
                </button>
            </li>
        </ul>



        <div class="tab-content">
            <div class="tab-pane fade {{ session('tab') == 'list' ? 'show active' : '' }}"
                id="staff-list" role="tabpanel">
                @include('staff.list')
            </div>

            <div class="tab-pane fade {{ session('tab') == 'add_staff' ? 'show active' : '' }}"
                id="add-staff" role="tabpanel">
                @include('staff.create')
            </div>

            <div class="tab-pane fade {{ session('tab') == 'staff_salary' ? 'show active' : '' }}"
                id="salary-management" role="tabpanel">
                @include('staff.salary')
            </div>
        </div>

    </div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        /* ================= STAFF STATUS TOGGLE ================= */
        $(document).on('change', '.staff-status', function () {
            let checkbox = $(this);
            let status = checkbox.prop('checked') ? 1 : 0;

            $.ajax({
                type: "PUT",
                dataType: "json",
                url: checkbox.data('url'),
                data: {
                    _token: "{{ csrf_token() }}",
                    status: status
                },
                success: function (data) {
                    Swal.fire('Success', data.message, 'success');
                },
                error: function () {
                    Swal.fire('Error', 'Something went wrong', 'error');
                    checkbox.prop('checked', !checkbox.prop('checked'));
                }
            });
        });

        /* ================= SEARCH ESC KEY ================= */
        const nameInput = document.querySelector('input[name="name"]');
        if (nameInput) {
            nameInput.addEventListener('keydown', function (e) {
                if (e.key === 'Escape') {
                    window.location.href = "{{ route('staff.index') }}";
                }
            });
        }

        /* ================= CATEGORY AUTO SUBMIT ================= */
        const categorySelect = document.getElementById('category_id');
        if (categorySelect) {
            categorySelect.addEventListener('change', function () {
                this.form.submit();
            });
        }

    });
</script>

<script>
    $(document).on('click', '.pay-btn', function () {

        let form = $(this).closest('.pay-form');

        Swal.fire({
            title: 'Confirm Salary Payment',
            text: 'Are you sure you want to pay salary for this month?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Pay',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });

    });

    $(document).on('click', '.bluk-pay-form', function () {

        let form = $(this).closest('.bluk-pay-form');

        Swal.fire({
            title: 'Confirm Salary Payment',
            text: 'Are you sure you want to pay salary for this month?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Pay',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });

    });
</script>

@endsection

