@extends('layouts.app')

@section('title', 'Salary Slip')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('staff.index') }}">Staff</a></li>
<li class="breadcrumb-item active">Salary Slip</li>
@endsection

@section('content')
<div class="page-content">
    <div class="card">
        <div class="card-header bg-light">
            <h5 class="mb-0">Salary Slip for {{ \Carbon\Carbon::parse($slip->pay_for_month.'-01')->format('F, Y') }}</h5>
        </div>
        <div class="card-body">
            {{-- Staff Info --}}
            <div class="mb-4">
                <h6>Staff Information</h6>
                <table class="table table-bordered table-sm">
                    <tr>
                        <th>Name</th>
                        <td>{{ $slip->staff->name }}</td>
                        <th>Category</th>
                        <td>{{ $slip->staff->category }}</td>
                    </tr>
                    <tr>
                        <th>Designation</th>
                        <td>{{ $slip->staff->designation }}</td>
                        <th>Phone</th>
                        <td>{{ $slip->staff->phone }}</td>
                    </tr>
                    <tr>
                        <th>Email</th>
                        <td>{{ $slip->staff->email ?? '-' }}</td>
                        <th>Financial Year</th>
                        <td>{{ $slip->financialYear->label ?? '-' }}</td>
                    </tr>
                </table>
            </div>

            {{-- Earnings --}}
            <div class="mb-4">
                <h6>Earnings</h6>
                <table class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>Basic</th>
                            <th>HRA</th>
                            <th>DA</th>
                            <th>TA</th>
                            <th>Medical</th>
                            <th>Conveyance</th>
                            <th>Washing</th>
                            <th>Special</th>
                            <th>Total Earnings</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ number_format($slip->basic,2) }}</td>
                            <td>{{ number_format($slip->hra,2) }}</td>
                            <td>{{ number_format($slip->da ?? 0,2) }}</td>
                            <td>{{ number_format($slip->ta ?? 0,2) }}</td>
                            <td>{{ number_format($slip->medical_allowance,2) }}</td>
                            <td>{{ number_format($slip->conveyance,2) }}</td>
                            <td>{{ number_format($slip->washing_allowance,2) }}</td>
                            <td>{{ number_format($slip->special_allowance,2) }}</td>
                            <td><strong>{{ number_format($slip->total_earnings,2) }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            {{-- Deductions --}}
            <div class="mb-4">
                <h6>Deductions</h6>
                <table class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>PF</th>
                            <th>ESI</th>
                            <th>Professional Tax</th>
                            <th>TDS</th>
                            <th>Advance</th>
                            <th>Others</th>
                            <th>Total Deductions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ number_format($slip->pf,2) }}</td>
                            <td>{{ number_format($slip->esi,2) }}</td>
                            <td>{{ number_format($slip->p_tax,2) }}</td>
                            <td>{{ number_format($slip->tds,2) }}</td>
                            <td>{{ number_format($slip->advance ?? 0,2) }}</td>
                            <td>{{ number_format($slip->others_deduction,2) }}</td>
                            <td><strong>{{ number_format($slip->total_deductions,2) }}</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            {{-- Net & Employer Contribution --}}
            <div class="mb-4">
                <h6>Net Salary & Employer Contribution</h6>
                <table class="table table-bordered table-sm">
                    <tr>
                        <th>Net Salary</th>
                        <td>{{ number_format($slip->net_salary,2) }}</td>
                        <th>Employer PF</th>
                        <td>{{ number_format($slip->employer_pf,2) }}</td>
                        <th>Employer ESI</th>
                        <td>{{ number_format($slip->employer_esi,2) }}</td>
                        <th>CTC</th>
                        <td>{{ number_format($slip->ctc,2) }}</td>
                    </tr>
                </table>
            </div>

            {{-- Payment Info --}}
            <div class="mb-4">
                <h6>Payment Info</h6>
                <table class="table table-bordered table-sm">
                    <tr>
                        <th>Month Paid</th>
                        <td>{{ \Carbon\Carbon::parse($slip->pay_for_month.'-01')->format('F, Y') }}</td>
                        <th>Paid Date</th>
                        <td>{{ \Carbon\Carbon::parse($slip->paid_date)->format('d-m-Y: H:i:s') }}</td>
                    </tr>
                </table>
            </div>

            {{-- Bank Info --}}
            @if($slip->staff->bankDetails)
            <div class="mb-4">
                <h6>Bank Details</h6>
                <table class="table table-bordered table-sm">
                    <tr>
                        <th>Bank Name</th>
                        <td>{{ $slip->staff->bankDetails->bank_name }}</td>
                        <th>Branch</th>
                        <td>{{ $slip->staff->bankDetails->branch_name }}</td>
                    </tr>
                    <tr>
                        <th>Account No.</th>
                        <td>{{ $slip->staff->bankDetails->acc_no }}</td>
                        <th>IFSC Code</th>
                        <td>{{ $slip->staff->bankDetails->ifsc_code }}</td>
                    </tr>
                    <tr>
                        <th>Account Holder</th>
                        <td colspan="3">{{ $slip->staff->bankDetails->acc_holder_name }}</td>
                    </tr>
                </table>
            </div>
            @endif

            <div class="text-center mt-4">
                <a href="{{ route('staff.index', ['tab'=>'staff_salary','month'=>request('month')]) }}" class="btn btn-secondary">Back</a>
                <button class="btn btn-primary" onclick="window.print()">Print Slip</button>
            </div>
        </div>
    </div>
</div>
@endsection
