<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Register New Student</h5>
    </div>

    <div class="card-body">
        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>Please fix the following errors:</strong>
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('students.store') }}" enctype="multipart/form-data">
            @csrf

            {{-- ================= PERSONAL INFORMATION ================= --}}
            <h6 class="text-muted mb-3">Personal Information</h6>

            <div class="row mb-3">
                <div class="col-md-12">
                    <label>Full Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" class="form-control" required>
                    @error('name') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <!-- <div class="col-md-6">
                    <label>Admission Number *</label>
                    <input type="text" name="admission_no" value="{{ old('admission_no') }}" class="form-control">
                    @error('admission_no') <small class="text-danger">{{ $message }}</small> @enderror
                </div> -->
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Date of Birth *</label>
                    <input type="date" name="dob" value="{{ old('dob') }}" class="form-control" required>
                    @error('dob') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <div class="col-md-6">
                    <label>Gender *</label>
                    <select name="gender" class="form-select" required>
                        <option value="">Select</option>
                        <option value="Male" {{ old('gender')=='Male'?'selected':'' }}>Male</option>
                        <option value="Female" {{ old('gender')=='Female'?'selected':'' }}>Female</option>
                        <!-- <option value="Other" {{ old('gender')=='Other'?'selected':'' }}>Other</option> -->
                    </select>
                    @error('gender') <small class="text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Nationality *</label>
                    <input type="text" name="nationality" value="{{ old('nationality','Indian') }}" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label>Mother Tongue *</label>
                    <input type="text" name="mother_tongue" value="{{ old('mother_tongue') }}" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Category *</label>
                    <select name="category" class="form-select" required>
                        <option value="GEN">GEN</option>
                        <option value="OBC">OBC</option>
                        <option value="SC">SC</option>
                        <option value="ST">ST</option>
                    </select>
                    @error('category') <small class="text-danger">{{ $message }}</small> @enderror
                </div>

                <div class="col-md-6">
                    <label>Caste *</label>
                    <input type="text" name="cast" value="{{ old('cast') }}" class="form-control" required>
                </div>
            </div>

            {{-- ================= ADDRESS ================= --}}
            <h6 class="text-muted mt-4">Address Information</h6>

            <div class="mb-3">
                <label>Permanent Address *</label>
                <textarea name="address" class="form-control" required>{{ old('address') }}</textarea>
                @error('address') <small class="text-danger">{{ $message }}</small> @enderror
            </div>

            <div class="mb-3">
                <label>Local Address *</label>
                <textarea name="local_address" class="form-control" required>{{ old('local_address') }}</textarea>
                @error('local_address') <small class="text-danger">{{ $message }}</small> @enderror
            </div>

            {{-- ================= CHECKBOXES ================= --}}
            <div class="row mb-3">
                <div class="col-md-4">
                    <input type="checkbox" name="belongs_to_minority_group" value="1" {{ old('belongs_to_minority_group')?'checked':'' }}>
                    Minority
                </div>
                <div class="col-md-4">
                    <input type="checkbox" name="is_disability_ph" value="1" {{ old('is_disability_ph')?'checked':'' }}>
                    Disability
                </div>
                <div class="col-md-4">
                    <input type="checkbox" name="is_transport_required" value="1" {{ old('is_transport_required')?'checked':'' }}>
                    Transport
                </div>
            </div>

            {{-- ================= CLASS DETAILS ================= --}}
            <h6 class="text-muted mt-4">Class Details</h6>

            <div class="row mb-3">

                {{-- CLASS --}}
                <div class="col-md-3">
                    <label class="form-label">Class *</label>
                    <select name="class_id" id="class_id"
                            class="form-select @error('class_id') is-invalid @enderror" required>
                        <option value="">Select Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}"
                                {{ old('class_id') == $class->id ? 'selected' : '' }}>
                                {{ $class->class_name }}
                            </option>
                        @endforeach
                    </select>
                    @error('class_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                {{-- SECTION --}}
                <div class="col-md-3">
                    <label class="form-label">Section *</label>
                    <select name="section_id" id="section_id"
                            class="form-select @error('section_id') is-invalid @enderror" required>
                        <option value="">Select Section</option>
                    </select>
                    @error('section_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>


                {{-- SESSION --}}
                <div class="col-md-3">
                    <label class="form-label">Session *</label>
                    <select name="session_id"
                            class="form-select @error('session_id') is-invalid @enderror" required>
                        <option value="">Select Session</option>
                        @foreach($sessions as $sec)
                            <option value="{{$sec->id}}" {{ old('session_id') == ($sec->id) ? 'selected' : '' }}>{{ $sec->name }}</option>
                        @endforeach
                    </select>
                    @error('session_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="col-md-3">
                    <label class="form-label">Financial Year *</label>
                    <select name="financial_year_id" id="financial_year"
                            class="form-select @error('financial_year_id') is-invalid @enderror" required>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ old('financial_year','2025-2026') ==
                                ($year->label) ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                    @error('financial_year_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

            </div>


            {{-- ================= PARENTS ================= --}}
            <h6 class="text-muted mt-4">Parent / Guardian</h6>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Name *</label>
                    <input type="text" name="father_name" value="{{ old('father_name') }}" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Mother Name *</label>
                    <input type="text" name="mother_name" value="{{ old('mother_name') }}" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Qualification</label>
                    <input type="text" name="father_qualification" value="{{ old('father_qualification') }}" class="form-control">
                </div>
                <div class="col-md-6">
                    <label>Mother Qualification</label>
                    <input type="text" name="mother_qualification" value="{{ old('mother_qualification') }}" class="form-control">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Occupation *</label>
                    <input type="text" name="father_occupation" value="{{ old('father_occupation') }}" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Mother Occupation *</label>
                    <input type="text" name="mother_occupation" value="{{ old('mother_occupation') }}" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Father Phone *</label>
                    <input type="tel" pattern="[0-9]{10}" maxlength="10" name="father_phone" value="{{ old('father_phone') }}" class="form-control" placeholder="10 digit mobile number" required>
                </div>
                <div class="col-md-6">
                    <label>Mother Phone *</label>
                    <input type="tel" pattern="[0-9]{10}" maxlength="10" name="mother_phone" value="{{ old('mother_phone') }}" class="form-control" placeholder="10 digit mobile number" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Guardian Name *</label>
                    <input type="text" name="guardian_name" value="{{ old('guardian_name') }}" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>Guardian Phone *</label>
                    <input type="tel" pattern="[0-9]{10}" maxlength="10" name="guardian_phone" value="{{ old('guardian_phone') }}" class="form-control" placeholder="10 digit mobile number" required>
                </div>
            </div>

            <div class="row mb-3">
                <label>Guardian Address *</label>
                <textarea name="guardian_address" class="form-control" required>{{ old('guardian_address') }}</textarea>
            </div>

            {{-- ================= DOCUMENTS ================= --}}
            <div class="row mb-4">
                <div class="col-md-6">
                    <label>Profile Image</label>
                    <input type="file" name="profile_image" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label>DOB Proof</label>
                    <input type="file" name="dob_photo_copy" class="form-control" required>
                </div>
            </div>

            <div class="d-flex gap-2 justify-content-end mt-3">
                <button class="btn btn-primary btn-sm">Register Student</button>

                <a href="{{ route('students.index') }}" class="btn btn-secondary btn-sm">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
