

<?php $__env->startSection('title','Dashboard'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Class Setup</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div id="school-setup-page" class="page-content">

        <h1 class="mb-4">Class Setup</h1>

        <div class="row">
            <div class="col-md-8">
                
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Classes & Sections</h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('class.add')); ?>" method="POST" class="mb-3">
                            <?php echo csrf_field(); ?>
                            <label class="form-label">Add New Class</label>
                            <div class="input-group">
                                <input type="text" name="class_name" class="form-control"
                                    placeholder="e.g., Class 5" required>
                                <button class="btn btn-outline-secondary" type="submit">Add Class</button>
                            </div>
                        </form>

                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Class Name</th>
                                    <th>Sections</th>
                                    <th>Total Students</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($class->class_name); ?></td>
                                        <td>
                                            <?php $__currentLoopData = $class->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span  class="badge bg-info section-delete-btn" 
                                                    data-id="<?php echo e($sec->id); ?>" 
                                                    data-url="<?php echo e(route('section.delete', $sec->id)); ?>">
                                                    <?php echo e($sec->section_name); ?>

                                                    <!-- <i class="fa fa-trash-o"></i> -->
                                                    <i class="bi bi-trash"></i>
                                                </span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td><?php echo e($class->students->count()); ?></td>
                                        <td>

                                            
                                            <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#sectionModal">
                                                Add Section
                                            </button>

                                            <button class="btn btn-sm btn-outline-primary class-edit-btn"
                                                data-id="<?php echo e($class->id); ?>"
                                                data-name="<?php echo e($class->class_name); ?>"
                                                data-url="<?php echo e(route('class.update', $class->id)); ?>"
                                                title="Edit Class">
                                                <i class="bi bi-pencil"></i>
                                            </button>

                                            <button class="btn btn-sm btn-outline-danger class-delete-btn"
                                                data-id="<?php echo e($class->id); ?>"
                                                data-url="<?php echo e(route('class.delete', $class->id)); ?>"
                                                title="Delete Class">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                <!-- <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">School Sessions</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="morning" checked>
                            <label class="form-check-label" for="morning">
                                Morning Session (6:00 AM - 1:00 PM)
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="day">
                            <label class="form-check-label" for="day">
                                Day Session (2:00 PM - 6:00 PM)
                            </label>
                        </div>
                    </div>
                </div> -->

            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <!-- Section Add Modal -->
    <div class="modal fade" id="sectionModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                
                <div class="modal-header">
                    <h5 class="modal-title">Add Section</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="sectionForm">

                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label class="form-label">Section Name</label>
                            <input type="text" name="section_name" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Class</label>
                            <select name="class_id" class="form-control" required>
                                <option value="">Select Class</option>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <button type="submit" id="sectionSubmitBtn"  class="btn btn-primary">Save</button>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <!-- Edit Class Modal -->
    <div class="modal fade" id="editClassModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editClassForm" action="">
                    <?php echo csrf_field(); ?> 
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Class</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_class_id" name="id">
                        <div class="mb-3">
                            <label>Class Name</label>
                            <input type="text" id="edit_class_name" name="class_name" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="updateClassBtn" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function(){

            // DELETE CLASS
            $('.class-delete-btn').on('click', function (e) {
                e.preventDefault();

                let btn = $(this);
                let itemUrl = btn.data('url');
                let row = btn.closest('tr');

                Swal.fire({
                    title: "Are you sure?",
                    text: "This class will be deleted!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#e3342f",
                    cancelButtonColor: "#6c757d",
                    confirmButtonText: "Yes, delete it",
                    cancelButtonText: "Cancel",
                }).then((result) => {
                    if (result.isConfirmed) {

                        $.ajax({
                            type: "DELETE",
                            url: itemUrl,
                            data: {
                                _token: "<?php echo e(csrf_token()); ?>"
                            },
                            success: function (res) {
                                if (res.success) {
                                    row.remove();
                                    Swal.fire("Deleted!", "Class deleted successfully.", "success");
                                }
                            },
                            error: function () {
                                toastr.error("Class not deleted!", "Failed");
                            }
                        });

                    }
                });
            });


            // DELETE SECTION
            $('.section-delete-btn').on('click', function(e){
                e.preventDefault();

                let badge = $(this);
                let itemUrl = badge.data('url');

                Swal.fire({
                    title: "Are you sure?",
                    text: "This section will be deleted!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#e3342f",
                    cancelButtonColor: "#6c757d",
                    confirmButtonText: "Yes, delete it",
                    cancelButtonText: "Cancel",
                }).then((result) => {
                    if (result.isConfirmed) {

                        $.ajax({
                            type: "DELETE",
                            url: itemUrl,
                            data: {
                                _token: "<?php echo e(csrf_token()); ?>"
                            },
                            success: function(res){
                                if(res.success){
                                    badge.remove();
                                    Swal.fire("Deleted!", "Section removed successfully.", "success");
                                }
                            },
                            error: function(){
                                toastr.error("Section not deleted!", "Failed");
                            }
                        });

                    }
                });

            });

        });
    </script>

    <script>
        $(document).ready(function () {

            $('#sectionForm').on('submit', function (e) {
                e.preventDefault();

                let btn = $('#sectionSubmitBtn'); // button id

                // Disable button + show loading
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Saving...');

                $.ajax({
                    url: "<?php echo e(route('section.add')); ?>",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Success!", res.message, "success");
                        $('#sectionModal').modal('hide');
                        $('#sectionForm')[0].reset();
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (key, value) {
                                msg += value + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        // Re-enable button after AJAX
                        btn.prop('disabled', false).html('Save');
                    }
                });
            });

        });
    </script>
    <script>
        $(document).ready(function() {

            // OPEN MODAL AND LOAD DATA
            $('.class-edit-btn').on('click', function () {

                let id = $(this).data('id');
                let name = $(this).data('name');
                let url = $(this).data('url');

                // fill modal
                $('#edit_class_id').val(id);
                $('#edit_class_name').val(name);
                $('#editClassForm').attr('action',url);

                // open modal
                $('#editClassModal').modal('show');
            });



            // UPDATE FORM SUBMIT
            $('#editClassForm').on('submit', function (e) {
                e.preventDefault();

                let id = $('#edit_class_id').val();
                let url = $('#editClassForm').attr('action');

                let btn = $('#updateClassBtn');
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Updated!", 'Class updated successfully', "success");
                        $('#editClassModal').modal('hide');
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (k, v) {
                                msg += v + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        btn.prop('disabled', false).html('Update');
                    }
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\school\resources\views/class/index.blade.php ENDPATH**/ ?>