<!-- ================= PROCESS MONTHLY SALARY ================= -->
<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Process Monthly Salary</h5>
    </div>

    <div class="card-body">
        <form method="GET">
            <input type="hidden" name="tab" value="staff_salary">

            <div class="row mb-3">
                <div class="col-md-4">
                    <input type="month"
                        name="month"
                        value="<?php echo e(request('month')); ?>"
                        class="form-control"
                        required>
                </div>

                <div class="col-md-4">
                    <select name="financial_year_id" class="form-select">
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>"
                                <?php echo e(request('financial_year_id') == $year->id ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-4">
                    <select name="category" class="form-select">
                        <option value="">All Category</option>
                        <option value="Teacher"
                            <?php echo e(request('category') == 'Teacher' ? 'selected' : ''); ?>>
                            Teacher
                        </option>
                        <option value="Non-Teacher"
                            <?php echo e(request('category') == 'Non-Teacher' ? 'selected' : ''); ?>>
                            Non-Teacher
                        </option>
                    </select>
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    Search & Preview
                </button>

                
                <a href="<?php echo e(url()->current()); ?>"
                class="btn btn-outline-secondary">
                    Clear Filter
                </a>
            </div>
        </form>

    </div>
</div>

<!-- ================= SALARY SLIP PREVIEW ================= -->
<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Salary Slip Preview</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive mb-3">
            <table class="table table-sm align-middle">
                <thead>
                    <tr>
                        <th>Staff Name</th>
                        <th>Basic</th>
                        <th>Total Earnings</th>
                        <th>Total Deduction</th>
                        <th>Employer Contribution</th>
                        <th>Net Salary</th>
                        <th>CTC</th>
                        <th>Status</th>
                        <th>Paid Date</th>
                        <th width="160">Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $salaryStaffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($row['staff']->name); ?></td>

                            <td><?php echo e(number_format($row['salary']->basic, 2)); ?></td>
                            <td><?php echo e(number_format($row['salary']->total_earnings, 2)); ?></td>
                            <td><?php echo e(number_format($row['salary']->total_deductions, 2)); ?></td>

                            <td>
                                <?php echo e(number_format(
                                    $row['salary']->employer_pf +
                                    $row['salary']->employer_esi,
                                    2
                                )); ?>

                            </td>

                            <td><?php echo e(number_format($row['salary']->net_salary, 2)); ?></td>

                            <td>
                                <strong>
                                    <?php echo e(number_format($row['salary']->ctc, 2)); ?>

                                </strong>
                            </td>

                            <td>
                                <?php if($row['status'] === 'paid'): ?>
                                    <span class="badge bg-success">Paid</span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($row['salary']->paid_date ? \Carbon\Carbon::parse($row['salary']->paid_date)->format('d-m-Y: H:i:s') : '--'); ?></td>
                            <td>
                                
                                <?php if($row['status'] === 'pending'): ?>
                                    <form method="POST"
                                        action="<?php echo e(route('staff.salary.pay')); ?>"
                                        class="d-inline pay-form">
                                        <?php echo csrf_field(); ?>

                                        <input type="hidden" name="staff_id" value="<?php echo e($row['staff']->id); ?>">
                                        <input type="hidden" name="financial_year_id" value="<?php echo e(request('financial_year_id')); ?>">
                                        <input type="hidden" name="month" value="<?php echo e(request('month')); ?>">

                                        <button type="button"
                                                class="btn btn-sm btn-primary pay-btn">
                                            Pay
                                        </button>
                                    </form>
                                <?php endif; ?>

                                
                                <?php if($row['status'] === 'paid'): ?>
                                    <a href="<?php echo e(route('staff.salary.slip', [$row['staff']->id, $row['salary']->pay_for_month])); ?>"
                                        target="_blank"
                                        class="btn btn-sm btn-outline-secondary">
                                        View Slip
                                    </a>

                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-muted">
                                No salary records found for selected month
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($salaryStaffs->where('status','pending')->count() > 0): ?>
            <div class="d-flex justify-content-end gap-2">
                <form action="<?php echo e(route('staff.pay-all-pending')); ?>" method="POST" class="d-inline bluk-pay-form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="month" value="<?php echo e(request('month')); ?>">
                    <input type="hidden" name="financial_year_id" value="<?php echo e(request('financial_year_id')); ?>">
                    <input type="hidden" name="category" value="<?php echo e(request('category')); ?>">
                    <button type="submit" class="btn btn-warning btn-sm mb-3">Pay All Pending Salaries</button>
                </form>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\school\resources\views/staff/salary.blade.php ENDPATH**/ ?>