School Management - Laravel Prototype (Option A) - Enhanced

What's included:
- Eloquent models with relationships.
- Laravel-style migrations (in database/migrations/) for main tables.
- Controllers wired to basic DB operations and validation.
- Simple session-based authentication (login/register/logout).
- Blade layout with partials (sidebar, navbar, footer) and modular partial views.
- Public assets copied from your prototype.

How to use:
1. Create a fresh Laravel project:
   composer create-project laravel/laravel school
2. Copy these files into the Laravel project, merging where needed. Important files:
   - app/Models/* -> app/Models/
   - app/Http/Controllers/* -> app/Http/Controllers/
   - database/migrations/* -> database/migrations/
   - resources/views/* -> resources/views/
   - public/css/styles.css -> public/css/styles.css
   - public/js/script.js -> public/js/script.js
   - routes/web.php -> routes/web.php (merge with care if you have existing routes)
3. Run migrations:
   php artisan migrate
4. Start server:
   php artisan serve
5. Visit /register to create the first admin user, then /login to sign in.

Notes & Limitations:
- This is a prototype scaffold. You may need to adjust namespaces or import statements based on your Laravel version.
- The session-based auth here is simple and self-contained; for production, use Laravel Breeze/Jetstream or full auth packages.
- If you already have a User model or auth setup, merge the code carefully.
