<?php

namespace App\Http\Controllers;

use App\Models\AcademicYear;
use App\Models\TransactionIncome;
use App\Models\TransactionExpense;
use App\Models\Student;
use App\Models\Staff;
use App\Models\IncomeHead;
use App\Models\ExpenseHead;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LedgerController extends Controller
{
    

    public function index(Request $request)
    {
        $tab="";
        $year = AcademicYear::where('status', 1)->firstOrFail();

        /* =========================
        INCOME LEDGER (HEAD-WISE TOTAL)
        ==========================*/
        $incomeLedger = TransactionIncome::select(
                'income_head_id',
                DB::raw('SUM(transaction_amount) as total_amount')
            )
            ->with('incomeHead:id,name')
            ->where('financial_year_id', $year->id)
            ->groupBy('income_head_id')
            ->orderBy('income_head_id')
            ->get()
            ->map(function ($row) {
                return [
                    'head_id'   => $row->incomeHead->id,
                    'head'   => $row->incomeHead->name ?? '—',
                    'total_amount'=> $row->total_amount,
                ];
            });

        /* =========================
        EXPENSE LEDGER (HEAD-WISE TOTAL)
        ==========================*/
        $expenseLedger = TransactionExpense::select(
                'expense_head_id',
                DB::raw('SUM(transaction_amount) as total_amount')
            )
            ->with('expenseHead:id,name')
            ->where('financial_year_id', $year->id)
            ->groupBy('expense_head_id')
            ->orderBy('expense_head_id')
            ->get()
            ->map(function ($row) {
                return [
                    'head_id'   => $row->expenseHead->id,
                    'head'   => $row->expenseHead->name ?? '—',
                    'total_amount' => $row->total_amount,
                ];
            });

        /* =========================
        VENDOR LEDGER (VENDOR-WISE TOTAL)
        ==========================*/
        $vendorLedger = TransactionExpense::select(
                'source_id',
                DB::raw('SUM(transaction_amount) as total_amount')
            )
            ->with('vendor:id,name')
            ->where([
                'financial_year_id' => $year->id,
                'source_type'       => 'vendor'
            ])
            ->groupBy('source_id')
            ->get()
            ->map(function ($row) {
                return [
                    'vendor'   => $row->vendor->name ?? '—',
                    'total_amount' => $row->total_amount,
                ];
            });

        // echo '<pre>';
        // print_r($incomeLedger->toArray());die;

        return view('ledgers.index', compact(
            'incomeLedger',
            'expenseLedger',
            'vendorLedger',
            'year',
            'tab'
        ));
    }

    public function incomeHeadLedger(Request $request, $headId)
    {
        $year = AcademicYear::where('status', 1)->firstOrFail();
        $head = IncomeHead::findOrFail($headId);

        $query = TransactionIncome::where('financial_year_id', $year->id)
            ->where('income_head_id', $headId)
            ->orderBy('transaction_date');

        if ($request->from_date) {
            $query->whereDate('transaction_date', '>=', $request->from_date);
        }
        if ($request->to_date) {
            $query->whereDate('transaction_date', '<=', $request->to_date);
        }

        $transactions = $query->get()
            ->groupBy('payment_method');

        return view('ledgers.income-head-ledger', compact(
            'transactions',
            'head',
            'year'
        ));
    }

    public function expenseHeadLedger(Request $request, $headId)
    {
        $year = AcademicYear::where('status', 1)->firstOrFail();
        $head = ExpenseHead::findOrFail($headId);

        $query = TransactionExpense::where('financial_year_id', $year->id)
            ->where('expense_head_id', $headId)
            ->orderBy('transaction_date');

        if ($request->from_date) {
            $query->whereDate('transaction_date', '>=', $request->from_date);
        }
        if ($request->to_date) {
            $query->whereDate('transaction_date', '<=', $request->to_date);
        }

        $transactions = $query->get()
            ->groupBy('payment_method');

        return view('ledgers.expense-head-ledger', compact(
            'transactions',
            'head',
            'year'
        ));
    }

}
