<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TransactionIncome extends Model
{
    protected $table = 'transaction_income';

    protected $fillable = [
        'transaction_id',
        'transaction_ref_id',
        'financial_year_id',
        'transaction_amount',
        'transaction_date',
        'transaction_details',
        'payment_method',
        'income_head_id',
        'transaction_reference_photo',
        'source_type',   // student / manual
        'source_id',
        'source_name'
    ];

    public function student()
    {
        return $this->belongsTo(Student::class, 'source_id');
    }

    public function incomeHead()
    {
        return $this->belongsTo(IncomeHead::class, 'income_head_id');
    }

    public function financialYear()
    {
        return $this->belongsTo(AcademicYear::class, 'financial_year_id');
    }
}

