<div class="card shadow-sm">
    <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Expense Ledger</h5>
    </div>

    <div class="card-body p-0">

        {{-- TABLE HEADER --}}
        <div class="d-flex justify-content-between px-3 py-2 border-bottom fw-semibold text-muted">
            <div>Head</div>
            <div>Action</div>
        </div>

        {{-- TABLE BODY --}}
        @forelse($expenseLedger as $row)
            <div class="d-flex justify-content-between px-3 py-2 border-bottom">
                <div>
                    {{ $row['head'] }} -
                    <span class="text-danger fw-bold">
                        ₹{{ number_format($row['total_amount'], 2) }}
                    </span>
                </div>
                <div>
                    <a href="{{ route('ledger.expense.head', $row['head_id']) }}"
                        class="btn btn-sm btn-outline-primary">
                        View Details
                    </a>
                </div>
            </div>
        @empty
            <div class="text-center text-muted py-3">
                No ladger records found
            </div>
        @endforelse

    </div>
</div>


