<div class="card shadow-sm">
    <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Income Ledger</h5>
    </div>

    <div class="card-body p-0">

        {{-- TABLE HEADER --}}
        <div class="d-flex justify-content-between px-3 py-2 border-bottom fw-semibold text-muted">
            <div>Head</div>
            <div>Action</div>
        </div>

        {{-- TABLE BODY --}}
        @forelse($incomeLedger as $row)
            <div class="d-flex justify-content-between px-3 py-2 border-bottom">
                <div>
                    {{ $row['head'] }} -
                    <span class="text-success fw-bold">
                        ₹{{ number_format($row['total_amount'], 2) }}
                    </span>
                </div>
                <div>
                    <!-- <button
                        type="button"
                        class="btn btn-sm btn-outline-primary view-income-ledger"
                        data-head="{{ $row['head_id'] ?? '' }}">
                        View Details
                    </button> -->
                    <a href="{{ route('ledger.income.head', $row['head_id']) }}"
                        class="btn btn-sm btn-outline-primary">
                        View Details
                    </a>
                </div>
            </div>
        @empty
            <div class="text-center text-muted py-3">
                No ladger records found
            </div>
        @endforelse

    </div>
</div>


