@extends('layouts.app')

@section('title','Students')

@section('breadcrumb')
<li class="breadcrumb-item active">Students</li>
@endsection

@section('content')
<div id="students-page" class="page-content">
    <h1 class="mb-4">Student Management</h1>
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="list" data-bs-toggle="tab" data-bs-target="#list-student" type="button" role="tab">Student List</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="register" data-bs-toggle="tab" data-bs-target="#register-student" type="button" role="tab">Register Student</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="bulk" data-bs-toggle="tab" data-bs-target="#bulk-student" type="button" role="tab">Bulk Upload</button>
        </li>
    </ul>

    <div class="tab-content">
        <!-- Student List Tab -->
        <div class="tab-pane fade show active" id="list-student" role="tabpanel">
            @include('students.list')
        </div>

        <!-- Register Student Tab -->
        <div class="tab-pane fade" id="register-student" role="tabpanel">
            @include('students.register')
        </div>

        <!-- Bulk Upload Tab -->
        <div class="tab-pane fade" id="bulk-student" role="tabpanel">
            @include('students.bluk')
        </div>
    </div>
</div>
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $(document).on('change', '.student-status', function() {
                let checkbox = $(this);
                let student_status = $(this).prop('checked') === true ? 1 : 0;
                $.ajax({
                    type: "PUT",
                    dataType: "json",
                    url: $(this).data('url'),
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: student_status
                    },
                    success: function(data) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: data.message
                        });
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'An error occurred while processing your request.'
                        });
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }

                });
            });

            document.querySelector('input[name="q"]').addEventListener('keydown', e => {
                if (e.key === 'Escape') window.location.href = "{{ route('students.index') }}";
            });

            

        });


        const classes = @json($classes);

        $(document).on('change', '#class_id', function () {

            const classId = $(this).val();
            let html = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);

            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    html += `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

            const $section = $('#reg_section_id');

            console.log('Section element found:', $section.length);

            $section
                .prop('disabled', false)
                .html(html);
        });

        $(document).on('change', '#sclass_id', function () {

            const classId = $(this).val();
            let html = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);

            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    html += `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

            const $section = $('#section_id');

            //console.log('Section element found:', $section.length);

            $section
                .prop('disabled', false)
                .html(html);
        });

        document.getElementById('section_id').addEventListener('change', function () {
            this.form.submit();
        });

        $(document).on('change', '#blk_class_id', function () {

            const classId = $(this).val();
            let html = '<option value="">Select Section</option>';

            const selectedClass = classes.find(c => c.id == classId);

            if (selectedClass && selectedClass.sections) {
                selectedClass.sections.forEach(section => {
                    html += `<option value="${section.id}">${section.section_name}</option>`;
                });
            }

            const $section = $('#blk_section_id');

            //console.log('Section element found:', $section.length);

            $section
                .prop('disabled', false)
                .html(html);
        });

        $(document).on('click', '#search_clear', function () {

            // Reset the form fields
            const form = $(this).closest('form')[0];
            form.reset();

            // Enable section dropdown (in case disabled)
            $('#section_id').prop('disabled', false);

            // Redirect to base URL (remove query string)
            window.location.href = "{{ route('students.index') }}";
        });
    </script>

    <script>
        $(document).ready(function () {

            let today = new Date();

            // Max = today (disable future)
            let maxDate = today.toISOString().split('T')[0];

            // Min = today - 1 month
            let minDate = new Date(
                today.getFullYear(),
                today.getMonth() - 3,
                today.getDate()
            ).toISOString().split('T')[0];

            $('#admission_date').attr({
                min: minDate,
                max: maxDate
            });



            maxDate = new Date(
                today.getFullYear() - 2,
                today.getMonth(),
                today.getDate()
            ).toISOString().split('T')[0];

            $('#dob').attr('max', maxDate);



            document.getElementById('profile_image').addEventListener('change', function(event) {
                let input = event.target;
                let file = input.files[0];
                let preview = document.getElementById('profilePreview');
                // Clear old preview

                let dt = new DataTransfer(); // For rebuilding file list

                if (file && file.type.startsWith('image/')) {
                    dt.items.add(file); // Keep valid file

                    let reader = new FileReader();
                    reader.onload = function(e) {
                        let col = document.createElement('div');
                        col.classList.add('col-md-3', 'mb-3');
                        col.innerHTML = `
                            <div class="card">
                                <img src="${e.target.result}" class="card-img-top img-fluid" 
                                    style="height:150px; object-fit:cover;">
                            </div>
                        `;
                        preview.innerHTML = "";
                        preview.appendChild(col);
                    };
                    reader.readAsDataURL(file);
                } else {
                    toastr.error("Only images are allowed!", 'Error');
                    input.value = ""; // reset invalid file
                }

                // Replace with filtered file list (empty if invalid)
                input.files = dt.files;
            });

            

        });
    </script>


    <script>
        document.getElementById('dob_photo_copy').addEventListener('change', function (event) {
            let input   = event.target;
            let file    = input.files[0];
            let preview = document.getElementById('dobPreview');

            preview.innerHTML = ""; // clear old previe
            let dt = new DataTransfer(); // rebuild file list

            if (!file) return;

            // ✅ Allowed types
            let allowedTypes = [
                'image/jpeg',
                'image/png',
                'image/jpg',
                'image/webp',
                'image/gif',
                'application/pdf'
            ];

            if (!allowedTypes.includes(file.type)) {
                toastr.error("Only images and PDF files are allowed!", "Error");
                input.value = "";
                return;
            }

            // keep valid file
            dt.items.add(file);
            input.files = dt.files;

            // 🖼️ IMAGE PREVIEW
            if (file.type.startsWith('image/')) {

                let reader = new FileReader();
                reader.onload = function (e) {

                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');

                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" 
                                class="card-img-top img-fluid"
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;

                    preview.appendChild(col);
                };

                reader.readAsDataURL(file);

            }
            // 📄 PDF PREVIEW (ICON + NAME)
            else if (file.type === 'application/pdf') {

                let col = document.createElement('div');
                col.classList.add('col-md-3', 'mb-3');

                col.innerHTML = `
                    <div class="card text-center p-3">
                        <i class="fa fa-file-pdf-o fa-3x text-danger mb-2"></i>
                        <p class="small">${file.name}</p>
                    </div>
                `;

                preview.appendChild(col);
            }

        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const urlParams = new URLSearchParams(window.location.search);
            const tab = urlParams.get('tab') || 'list';

            const tabMap = {
                list: 'list',
                register: 'register',
                bulk: 'bulk'
            };

            if (tabMap[tab]) {
                console.log(tabMap[tab]);
                const triggerEl = document.getElementById(tabMap[tab]);
                if (triggerEl) {
                    new bootstrap.Tab(triggerEl).show();
                }
            }
        });
    </script>

    <script>
        $(document).ready(function () {

            let today = new Date();

            // Max = today (disable future)
            let maxDate = today.toISOString().split('T')[0];

            // Min = today - 1 month
            let minDate = new Date(
                today.getFullYear(),
                today.getMonth() - 3,
                today.getDate()
            ).toISOString().split('T')[0];

            $('#admission_date').attr({
                min: minDate,
                max: maxDate
            });

            

            maxDate = new Date(
                today.getFullYear() - 2,
                today.getMonth(),
                today.getDate()
            ).toISOString().split('T')[0];

            $('#dob').attr('max', maxDate);

        });


        $(document).on('click', '.btn-delete-student', function () {

            let button = $(this);
            let route  = button.data('route');

            Swal.fire({
                title: 'Confirm Student Deletion',
                text: 'If the student has paid any fees, the account will be deactivated instead of deleted.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, Delete',
                cancelButtonText: 'Cancel'
            }).then((result) => {

                if (!result.isConfirmed) return;

                $.ajax({
                    url: route,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    beforeSend: function () {
                        //button.prop('disabled', true);
                    },
                    success: function (res) {

                        //button.prop('disabled', false);

                        let row = button.closest('tr');

                        // ✅ HARD DELETE
                        if (res.type === 'deleted') {

                            Swal.fire('Deleted!', res.message, 'success');

                            row.fadeOut(300, function () {
                                $(this).remove();
                            });
                        }

                        // ✅ DEACTIVATE → AUTO TOGGLE OFF
                        if (res.type === 'deactivated') {

                            Swal.fire('Deactivated!', res.message, 'info');

                            let toggle = row.find('.student-status');

                            toggle.prop('checked', false);
                            //toggle.prop('disabled', true); // 🔒 lock toggle

                            //button.prop('disabled', true);
                        }

                        if (res.type === 'already_deactivated') {
                            Swal.fire(
                                'Info',
                                res.message,
                                'info'
                            );
                        }

                    },
                    error: function (xhr) {

                        Swal.fire(
                            'Error!',
                            xhr.responseJSON?.message || 'Unable to process request',
                            'error'
                        );

                        button.prop('disabled', false);
                    }
                });
            });
        });
    </script>



@endsection
