{{-- ===================== SEARCH / FILTER CARD ===================== --}}
<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="d-flex gap-2">
                <div class="col">
                    <h5 class="mb-0">Search Transactions</h5>
                </div>
                <button 
                    type="button"
                    class="btn btn-outline-danger btn-sm"
                    data-bs-toggle="modal"
                    data-bs-target="#expenseModal"
                >
                    <i class="bi bi-plus-circle me-1"></i> Add Expense
                </button>

            </div>
        </div>
    </div>

    <div class="card-body">
        <form method="GET" action="{{ route('transactions.index') }}" class="search-form">
            <input type="hidden" name="type" value="expense">
            <div class="row mb-3">

                {{-- Financial Year --}}
                <div class="col-md-2">
                    <select name="financial_year_id" class="form-select form-select-sm">
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Month --}}
                <div class="col-md-2">
                    <input
                        type="month"
                        name="month"
                        class="form-control form-control-sm"
                        value="{{ request('type')== 'expense' ? request('month') :'' }}">
                </div>
                <!-- <div class="col-md-3">
                    <select name="type" class="form-select form-select-sm">
                        <option value="">Select Transaction Type</option>
                        <option value="income" {{ request('type') == 'income' ? 'selected' : '' }}>Income</option>
                        <option value="expense" {{ request('type') == 'expense' ? 'selected' : '' }}>Expense</option>
                    </select>
                </div> -->

                {{-- Search --}}
                <div class="col-md-5">
                    <input
                        type="search"
                        name="q"
                        value="{{ request('type')== 'expense' ? request('q') :'' }}"
                        class="form-control form-control-sm"
                        placeholder="Search by Ref.Transaction ID / Money Receipt No / Head Name">
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary">
                        Filter
                    </button>

                    <a href="{{ route('transactions.index') }}?type=expense"
                    class="btn btn-outline-secondary">
                        Clear Filter
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- ===================== TRANSACTIONS TABLE ===================== --}}
<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Transaction History</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th title="Income / Expense Head">Income / Expense Head</th>
                        <th title="Transaction Type">Transactions Type</th>
                        <th title="Transaction ID">Ref. Transactions ID/Money Receipt No.</th>
                        <th title="Payment Amount">Amount</th>
                        <th title="Payment Method">Payment Method</th>
                        <th title="Payment Date">Payment Date</th>
                        <th title="Actions">Actions</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($expense as $t)
                        <tr class="{{ $t->type === 'income' ? 'table-success' : 'table-danger' }}">
                            <td>
                                {{ $t->expense_head_name ?? '_' }}
                            </td>
                            <td>{{ ucfirst($t->type) }}</td>
                            <td>{{ $t->transaction_ref_id }}</td>
                            <td>{{ number_format($t->transaction_amount, 2) }}</td>
                            <td>{{ ucfirst($t->payment_method) }}</td>
                            <td>{{ \Carbon\Carbon::parse($t->transaction_date)->format('d M Y') }}</td>
                            <td>
                                <button
                                    class="mt-1 btn btn-outline-secondary btn-sm view-transaction"
                                    data-url="{{ route('transactions.show', ['type' => $t->type, 'id' => $t->id]) }}">
                                    View
                                </button>
                                @if( $t->expense_head_id != 1 ) 
                                <button
                                    class="mt-1 btn btn-sm btn-outline-primary edit-transaction"
                                    data-id="{{ $t->id }}"
                                    data-type="{{ $t->type }}"
                                    data-edit-url="{{ route('transactions.edit', [$t->type, $t->id]) }}">
                                    Edit
                                </button>

                                <button
                                    class="mt-1 btn btn-sm btn-outline-danger  delete-transaction"
                                    data-url="{{ route('transactions.destroy', ['type' => $t->type, 'id' => $t->id]) }}">
                                    Delete
                                </button>

                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">
                                No Transactions Found
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div class="mt-3">
            {{ $expense->appends(request()->query())->appends('type','expense')->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
