@extends('layouts.app')

@section('title','Transaction History')

@section('breadcrumb')
<li class="breadcrumb-item active">Transactions</li>
@endsection

{{-- @section('content')
<div id="fees-page" class="page-content">
    <h1 class="mb-4">Transaction History</h1>
    @include('transactions.list')
</div>
@endsection --}}

@section('content')
<div id="fees-page" class="page-content">
    <h1 class="mb-4">Transaction History</h1>
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="income_history" data-bs-toggle="tab" data-bs-target="#income-history" type="button" role="tab" data-type="income">Income History</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link " id="expense_history" data-bs-toggle="tab" data-bs-target="#expense-history" type="button" role="tab" data-type="expense">Expense History</button>
        </li>
    </ul>

    <div class="tab-content">

        <div class="tab-pane fade show active" id="income-history" role="tabpanel">
            @include('transactions.income')
        </div>
        <!-- Fee Configuration Tab -->
        <div class="tab-pane fade" id="expense-history" role="tabpanel">
            @include('transactions.expense')
        </div>
    </div>
</div>
@endsection

@section('modal')

    <div class="modal fade" id="incomeModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <form id="incomeForm">
                @csrf

                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title">Add Income</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <div class="row g-3">

                            {{-- Income Head --}}
                            <div class="col-md-6">
                                <label class="form-label">Income Head *</label>
                                <select class="form-select" name="income_head_id" id="income_head_id" required>
                                    <option value="">Select</option>
                                    @foreach($income_heads as $head)
                                        <option value="{{ $head->id }}">{{ $head->name }}</option>
                                    @endforeach
                                </select>
                            </div>


                            {{-- Amount --}}
                            <div class="col-md-6">
                                <label class="form-label">Amount *</label>
                                <input type="number" class="form-control" name="transaction_amount"  required>
                            </div>

                            {{-- Payment Method --}}
                            <div class="col-md-6">
                                <label class="form-label">Payment Method *</label>
                                <select class="form-select" name="payment_method" required>
                                    <option value="cash">Cash</option>
                                    <option value="online">Online</option>
                                    <option value="bank">Bank</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>

                            {{-- Transaction Date --}}
                            <div class="col-md-6">
                                <label class="form-label" required>Transaction Date *</label>
                                <input type="date" class="form-control trans-date" name="transaction_date" required>
                            </div>

                            {{-- Reference ID --}}
                            <div class="col-md-6">
                                <label class="form-label">Transaction Ref. ID / Money Receipt No*</label>
                                <input type="text" class="form-control" name="transaction_ref_id" required>
                            </div>

                            {{-- Reference ID --}}
                            <div class="col-md-6">
                                <label class="form-label">Transaction Ref. Pdf/Image</label>
                                <input type="file" class="form-control transaction-ref-file" name="transaction_reference_photo" id="transaction_ref_file" accept="image/*,application/pdf">
                            </div>

                            {{-- Source Type 
                            <div class="col-md-6">
                                <label class="form-label">Income Source Type *</label>
                                <select name="source_type" id="source_type" class="form-select" required>
                                    <option value="">Select Source</option>
                                    <option value="student">Student</option>
                                    <option value="guest">Guest</option>
                                    <option value="other">Other</option>
                                </select>
                            </div> --}}


                            {{-- STUDENT SELECT (SELECT2) 
                            <div class="col-md-6 d-none" id="studentSelectBlock">
                                <label class="form-label">Select Student *</label>
                                <!-- <select class="form-select" name="source_id" id="student_id" style="width:100%">
                                </select> -->
                                <select id="student_id" class="form-select" name="source_id"></select>
                            </div>
                            <div class="col-md-6 d-none" id="guestBlock">
                                <label class="form-label">Guest Name / Organization Name *</label>
                                <input type="text" name="source_name" id="guest_name" class="form-control">
                            </div> --}}


                            {{-- Description --}}
                            <div class="col-md-12">
                                <label class="form-label">Narration</label>
                                <textarea class="form-control" name="transaction_details"></textarea>
                            </div>

                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="incomeBtn">
                            Save Income
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="expenseModal" tabindex="-1">
        <div class="modal-dialog modal-lg">

            <form id="expenseForm" enctype="multipart/form-data">
                @csrf

                <div class="modal-content">

                    <!-- HEADER -->
                    <div class="modal-header">
                        <h5 class="modal-title">Add Expense</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <!-- BODY -->
                    <div class="modal-body">
                        <div class="row g-3">

                            <!-- Expense Head -->
                            <div class="col-md-6">
                                <label class="form-label">Expense Head *</label>
                                <select class="form-select" name="expense_head_id" required>
                                    <option value="">Select</option>
                                    @foreach($expense_heads as $head)
                                        <option value="{{ $head->id }}">{{ $head->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Amount -->
                            <div class="col-md-6">
                                <label class="form-label">Amount *</label>
                                <input type="number" class="form-control" name="transaction_amount" min="1" required>
                            </div>

                            <!-- Payment Method -->
                            <div class="col-md-6">
                                <label class="form-label">Payment Method *</label>
                                <select class="form-select" name="payment_method" required>
                                    <option value="cash">Cash</option>
                                    <option value="online">Online</option>
                                    <option value="bank">Bank</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>

                            <!-- Transaction Date -->
                            <div class="col-md-6">
                                <label class="form-label">Transaction Date *</label>
                                <input type="date" class="form-control trans-date" name="transaction_date" required>
                            </div>

                            <!-- Reference ID -->
                            <div class="col-md-6">
                                <label class="form-label">Voucher / Reference No *</label>
                                <input type="text" class="form-control" name="transaction_ref_id" required>
                            </div>

                            <!-- Reference File -->
                            <div class="col-md-6">
                                <label class="form-label">Voucher (PDF / Image)</label>
                                <input type="file" class="form-control transaction-ref-file"
                                    name="transaction_reference_photo"
                                    accept="image/*,application/pdf">
                            </div>

                            <!-- PAY TO -->
                            <div class="col-md-6">
                                <label class="form-label">Pay To</label>
                                <select class="form-select" name="source_type" id="expense_source_type">
                                    <option value="">Select</option>
                                    <option value="staff">Staff</option>
                                    <option value="vendor">Vendor</option>
                                </select>
                            </div>

                            <!-- STAFF SELECT -->
                            <div class="col-md-6 d-none" id="expenseStaffBlock">
                                <label class="form-label">Select Staff *</label>
                                <select class="form-select" name="source_id" id="expense_staff_id"></select>
                            </div>

                            <!-- VENDOR / OTHER NAME -->
                            <div class="col-md-6 d-none" id="expenseVendorBlock">
                                <label class="form-label">Vendor *</label>
                                <!-- <input type="text" class="form-control" name="source_id" id="expense_vendor_id"> -->
                                <select class="form-select" name="source_id" id="expense_vendor_id"></select>
                            </div>

                            <!-- NARRATION -->
                            <div class="col-md-12">
                                <label class="form-label">Narration</label>
                                <textarea class="form-control" name="transaction_details"></textarea>
                            </div>

                        </div>
                    </div>

                    <!-- FOOTER -->
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-danger" id="expenseBtn">
                            Save Expense
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>

    {{-- ================= EXPENSE EDIT MODAL ================= --}}
    <div class="modal fade" id="expenseEditModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <form id="expenseEditForm" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <input type="hidden" id="edit_expense_id">

                <div class="modal-content">

                    {{-- HEADER --}}
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Expense</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    {{-- BODY --}}
                    <div class="modal-body">
                        <div class="row g-3">

                            {{-- Expense Head --}}
                            <div class="col-md-6">
                                <label class="form-label">Expense Head *</label>
                                <select class="form-select" name="expense_head_id" required>
                                    <option value="">Select</option>
                                    @foreach($expense_heads as $head)
                                        <option value="{{ $head->id }}">{{ $head->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Amount --}}
                            <div class="col-md-6">
                                <label class="form-label">Amount *</label>
                                <input type="number" class="form-control" name="transaction_amount" min="1" required>
                            </div>

                            {{-- Payment Method --}}
                            <div class="col-md-6">
                                <label class="form-label">Payment Method *</label>
                                <select class="form-select" name="payment_method" required>
                                    <option value="cash">Cash</option>
                                    <option value="online">Online</option>
                                    <option value="bank">Bank</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>

                            {{-- Date --}}
                            <div class="col-md-6">
                                <label class="form-label">Transaction Date *</label>
                                <input type="date" class="form-control trans-date" name="transaction_date" required>
                            </div>

                            {{-- Reference --}}
                            <div class="col-md-6">
                                <label class="form-label">Voucher / Reference No *</label>
                                <input type="text" class="form-control transaction-ref-file" name="transaction_ref_id" required>
                            </div>

                            {{-- File --}}
                            <div class="col-md-6">
                                <label class="form-label">Voucher (PDF / Image)</label>
                                <input type="file" class="form-control"
                                    name="transaction_reference_photo"
                                    accept="image/*,application/pdf">
                                <small class="text-muted">Leave blank to keep existing</small>
                            </div>

                            {{-- PAY TO --}}
                            <div class="col-md-6">
                                <label class="form-label">Pay To</label>
                                <select class="form-select" name="source_type" id="edit_expense_source_type">
                                    <option value="">Select</option>
                                    <option value="staff">Staff</option>
                                    <option value="vendor">Vendor</option>
                                </select>
                            </div>

                            {{-- STAFF --}}
                            <div class="col-md-6 d-none" id="editExpenseStaffBlock">
                                <label class="form-label">Select Staff *</label>
                                <select class="form-select" name="source_id" id="edit_expense_staff_id"></select>
                            </div>

                            {{-- VENDOR --}}
                            <div class="col-md-6 d-none" id="editExpenseVendorBlock">
                                <label class="form-label">Vendor *</label>
                                <!-- <input type="text" class="form-control" name="source_id" id="expense_vendor_id"> -->
                                <select class="form-select" name="source_id" id="edit_expense_vendor_id"></select>
                            </div>

                            {{-- Narration --}}
                            <div class="col-md-12">
                                <label class="form-label">Narration</label>
                                <textarea class="form-control" name="transaction_details"></textarea>
                            </div>

                        </div>
                    </div>

                    {{-- FOOTER --}}
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-danger" id="expenseEditBtn">
                            Update Expense
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>

    {{-- ================= INCOME EDIT MODAL ================= --}}
    <div class="modal fade" id="incomeEditModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <form id="incomeEditForm" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <input type="hidden" id="edit_income_id">

                <div class="modal-content">

                    {{-- HEADER --}}
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Income</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    {{-- BODY --}}
                    <div class="modal-body">
                        <div class="row g-3">

                            {{-- Income Head --}}
                            <div class="col-md-6">
                                <label class="form-label">Income Head *</label>
                                <select class="form-select" name="income_head_id" required>
                                    <option value="">Select</option>
                                    @foreach($income_heads as $head)
                                        <option value="{{ $head->id }}">{{ $head->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Amount --}}
                            <div class="col-md-6">
                                <label class="form-label">Amount *</label>
                                <input type="number" class="form-control" name="transaction_amount" min="1" required>
                            </div>

                            {{-- Payment Method --}}
                            <div class="col-md-6">
                                <label class="form-label">Payment Method *</label>
                                <select class="form-select" name="payment_method" required>
                                    <option value="cash">Cash</option>
                                    <option value="online">Online</option>
                                    <option value="bank">Bank</option>
                                    <option value="cheque">Cheque</option>
                                </select>
                            </div>

                            {{-- Date --}}
                            <div class="col-md-6">
                                <label class="form-label">Transaction Date *</label>
                                <input type="date" class="form-control trans-date" name="transaction_date" required>
                            </div>

                            {{-- Reference --}}
                            <div class="col-md-6">
                                <label class="form-label">Receipt / Reference No *</label>
                                <input type="text" class="form-control" name="transaction_ref_id" required>
                            </div>

                            {{-- File --}}
                            <div class="col-md-6">
                                <label class="form-label">Receipt (PDF / Image)</label>
                                <input type="file" class="form-control transaction-ref-file"
                                    name="transaction_reference_photo"
                                    accept="image/*,application/pdf">
                            </div>

                            {{-- SOURCE 
                            <div class="col-md-6">
                                <label class="form-label">Source *</label>
                                <select class="form-select" name="source_type" id="edit_income_source_type" required>
                                    <option value="">Select</option>
                                    <option value="student">Student</option>
                                    <option value="guest">Guest</option>
                                    <option value="organization">Organization</option>
                                </select>
                            </div> --}}

                            {{-- STUDENT 
                            <div class="col-md-6 d-none" id="editIncomeStudentBlock">
                                <label class="form-label">Select Student *</label>
                                <select class="form-select" name="source_id" id="edit_income_student_id"></select>
                            </div> --}}

                            {{-- GUEST 
                            <div class="col-md-6 d-none" id="editIncomeGuestBlock">
                                <label class="form-label">Guest / Organization Name *</label>
                                <input type="text" class="form-control" name="source_name">
                            </div> --}}

                            {{-- Narration --}}
                            <div class="col-md-12">
                                <label class="form-label">Narration</label>
                                <textarea class="form-control" name="transaction_details"></textarea>
                            </div>

                        </div>
                    </div>

                    {{-- FOOTER --}}
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success" id="incomeEditBtn">
                            Update Income
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>




    <div class="modal fade" id="transactionModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Transaction Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    {{-- ================= TRANSACTION INFO ================= --}}
                    <h6 class="text-primary mb-3">Transaction Info</h6>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Transaction ID</label>
                            <div id="t_transaction_id" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Transaction Ref. ID / Money Receipt No.</label>
                            <div id="t_ref_id" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Financial Year</label>
                            <div id="t_financial_year" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Amount</label>
                            <div id="t_amount" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Transaction Date</label>
                            <div id="t_date" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Payment Method</label>
                            <div id="t_method" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small" id="ie_head">Head</label>
                            <div id="t_head" class="fw-semibold"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Transaction Ref. Imge/PDF</label>
                            <div id="t_photo" data-storage-url="{{ asset('storage') }}"></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Transaction Narration</label>
                            <div id="t_details" class="fw-semibold"></div>
                        </div>
                    </div>

                    {{-- ================= STUDENT INFO =================  --}}
                    <div id="incomeSourceBlock" class="d-none mt-4">
                        <hr>
                        <h6 class="text-success mb-3">Income Source Details</h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="text-muted small">Guest / Organization Name</label>
                                <div id="is_name" class="fw-semibold"></div>
                            </div>
                        </div>
                    </div>

                    <div id="studentBlock" class="d-none mt-4">
                        <hr>
                        <h6 class="text-success mb-3">Student Details</h6>

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="text-muted small">Student Name</label>
                                <div id="s_name" class="fw-semibold"></div>
                            </div>

                            <div class="col-md-6">
                                <label class="text-muted small">Admission No</label>
                                <div id="s_admission" class="fw-semibold"></div>
                            </div>

                            <div class="col-md-6">
                                <label class="text-muted small">Class</label>
                                <div id="s_class" class="fw-semibold"></div>
                            </div>

                            <div class="col-md-6">
                                <label class="text-muted small">Section</label>
                                <div id="s_section" class="fw-semibold"></div>
                            </div>
                        </div>
                    </div>

                    {{-- ================= STAFF INFO ================= --}}
                    <div id="expenseSourceBlock" class="d-none mt-4">
                        <hr>
                        <h6 class="text-danger mb-3">Vendor Details</h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="text-muted small">Vendor Name</label>
                                <div id="es_name" class="fw-semibold"></div>
                            </div>
                        </div>
                    </div>

                    <div id="staffBlock" class="d-none mt-4">
                        <hr>
                        <h6 class="text-danger mb-3">Staff Details</h6>

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="text-muted small">Staff Name</label>
                                <div id="st_name" class="fw-semibold"></div>
                            </div>

                            <div class="col-md-6">
                                <label class="text-muted small">Designation</label>
                                <div id="st_designation" class="fw-semibold"></div>
                            </div>

                            <div class="col-md-6">
                                <label class="text-muted small">Category</label>
                                <div id="st_category" class="fw-semibold"></div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">
                        Close
                    </button>
                </div>

            </div>
        </div>
    </div>

    

@endsection

@section('script')

<script>
    document.addEventListener('DOMContentLoaded', function () {

        document.querySelectorAll('.view-transaction').forEach(btn => {

            btn.addEventListener('click', function () {

                const url = this.dataset.url;

                fetch(url)
                    .then(res => res.json())
                    .then(data => {

                        /* ================= TRANSACTION ================= */
                        document.getElementById('t_transaction_id').innerText = data.transaction_id ?? '—';
                        document.getElementById('t_ref_id').innerText         = data.transaction_ref_id ?? '—';
                        document.getElementById('t_financial_year').innerText = data.financial_year ?? '—';
                        document.getElementById('t_amount').innerText         = data.transaction_amount ?? '—';
                        document.getElementById('t_date').innerText           = data.transaction_date ?? '—';
                        document.getElementById('t_method').innerText         = data.payment_method ? data.payment_method.charAt(0).toUpperCase() + data.payment_method.slice(1) : '—';
                        document.getElementById('t_head').innerText           = data.head_name ?? '—';
                        document.getElementById('t_details').innerText        = data.transaction_details ?? '—';
                        let photoBox   = document.getElementById('t_photo');
                        let storageUrl = photoBox.dataset.storageUrl;

                        if (data.transaction_reference_photo) {
                            photoBox.innerHTML = `
                                <a class="btn btn-sm btn-outline-primary"
                                href="${storageUrl}/${data.transaction_reference_photo}"
                                target="_blank"
                                download>
                                    <i class="bi bi-file-earmark-arrow-down me-1"></i>
                                    Download the uploaded file
                                </a>
                            `;
                        } else {
                            photoBox.innerText = '—';
                        }

                        /* ================= HEAD LABEL ================= */
                        document.getElementById('ie_head').innerText =
                            (data.type === 'income') ? 'Income Head' : 'Expense Head';

                        /* ================= BLOCKS ================= */
                        const studentBlock = document.getElementById('studentBlock');
                        const incomeSourceBlock   = document.getElementById('incomeSourceBlock');


                        const staffBlock   = document.getElementById('staffBlock');
                        const expenseSourceBlock   = document.getElementById('expenseSourceBlock');
                        

                        

                        // Hide all first (important)
                        studentBlock.classList.add('d-none');
                        incomeSourceBlock.classList.add('d-none');


                        staffBlock.classList.add('d-none');
                        expenseSourceBlock.classList.add('d-none');

                        /* ================= STUDENT ================= */
                       if (
                            data.type === 'income' 
                            && data.source_type === 'student' 
                            && data.income_expense_head_id == 1
                        ) {
                            studentBlock.classList.remove('d-none');

                            document.getElementById('s_name').innerText      = data.student_name ?? '—';
                            document.getElementById('s_admission').innerText = data.admission_no ?? '—';
                            document.getElementById('s_class').innerText     = data.class_name ?? '—';
                            document.getElementById('s_section').innerText   = data.section_name ?? '—';
                        } 
                        // else if (
                        //     data.type === 'income' &&
                        //     data.source_type != 'student' 
                        // ) {
                        //     incomeSourceBlock.classList.remove('d-none');

                        //     document.getElementById('is_name').innerText = data.source_name ?? '—';
                        // }


                        /* ================= STAFF (SALARY EXPENSE) ================= */
                        if (
                            data.type === 'expense' &&
                            data.source_type === 'staff' 
                            //&& data.income_expense_head_id == 1
                        ) {
                            staffBlock.classList.remove('d-none');

                            document.getElementById('st_name').innerText        = data.staff_name ?? '—';
                            document.getElementById('st_designation').innerText = data.designation ?? '—';
                            document.getElementById('st_category').innerText    = data.category ?? '—';
                        } else if (
                            data.type === 'expense'
                            && data.source_type == 'vendor'
                        ) {
                            expenseSourceBlock.classList.remove('d-none');

                            document.getElementById('es_name').innerText = data.vendor_name ?? '—';
                        }

                        /* ================= SHOW MODAL ================= */
                        new bootstrap.Modal(
                            document.getElementById('transactionModal')
                        ).show();

                    })
                    .catch(err => {
                        console.error(err);
                        alert('Failed to load transaction details');
                    });
            });

        });

    });
</script>

<script>
    $(document).ready(function () {

        $('#source_type').on('change', function () {

            const sourceType = $(this).val();

            $('#studentSelectBlock, #guestBlock').addClass('d-none');

            if (sourceType === 'student') {
                $('#studentSelectBlock').removeClass('d-none');
                initStudentSelect2();
            } else if (sourceType) {
                $('#guestBlock').removeClass('d-none');
            }
        });

        function initStudentSelect2() {

            // destroy if already initialized
            if ($('#student_id').hasClass('select2-hidden-accessible')) {
                $('#student_id').select2('destroy');
            }

            $('#student_id').select2({
                theme: 'bootstrap-5',
                dropdownParent: $('#incomeModal'), // 🔥 REQUIRED
                placeholder: 'Search student by name / admission no',
                allowClear: true,
                width: '100%',
                minimumInputLength: 2,
                ajax: {
                    url: "{{ route('students.search') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return { q: params.term };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(s => ({
                                id: s.id,
                                text: `${s.admission_no} - ${s.name} (${s.class_name}-${s.section_name})`
                            }))
                        };
                    }
                }
            });
        }

        // Reset modal on open
        $('#incomeModal').on('show.bs.modal', function () {
            $('#incomeForm')[0].reset();
            $('#studentSelectBlock').addClass('d-none');

            if ($('#student_id').hasClass('select2-hidden-accessible')) {
                $('#student_id').val(null).trigger('change');
            }
        });

        $(document).on('change', '.transaction-ref-file', function (event) {

            let input = event.target;
            let file  = input.files[0];

            let dt = new DataTransfer(); // rebuild file list

            if (!file) return;

            // ✅ Allowed types
            let allowedTypes = [
                'image/jpeg',
                'image/png',
                'image/jpg',
                'image/webp',
                'image/gif',
                'application/pdf'
            ];

            if (!allowedTypes.includes(file.type)) {
                toastr.error("Only images and PDF files are allowed!", "Error");
                input.value = "";
                return;
            }

            // ✅ keep valid file
            dt.items.add(file);
            input.files = dt.files;
        });


    });
</script>

<script>
    $('#incomeForm').on('submit', function (e) {
        e.preventDefault();

        let formData = new FormData(this);

        $.ajax({
            url: "{{ route('transaction.income.store') }}",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,

            beforeSend() {
                $('#incomeBtn').prop('disabled', true).text('Saving...');
            },

            success(res) {
                toastr.success(res.message);

                $('#incomeModal').modal('hide');
                $('#incomeForm')[0].reset();
                $('#studentSelectBlock, #guestBlock').addClass('d-none');
                $('#student_id').val(null).trigger('change');

                location.reload();
            },

            error(xhr) {
                if (xhr.status === 422) {
                    Object.values(xhr.responseJSON.errors)
                        .forEach(err => toastr.error(err[0]));
                } else {
                    toastr.error('Income save failed');
                }
            },

            complete() {
                $('#incomeBtn').prop('disabled', false).text('Save Income');
            }
        });
    });
</script>

<script>
    $(document).ready(function () {

        // 🔹 Toggle Pay To
        $('#expense_source_type').on('change', function () {

            const type = $(this).val();

            $('#expenseStaffBlock').addClass('d-none');
            $('#expenseVendorBlock').addClass('d-none');

            if (type === 'staff') {
                $('#expenseStaffBlock').removeClass('d-none');
                $('#expense_staff_id').prop('required', true);
                $('#expense_vendor_id').prop('required', false).val(null).trigger('change');
                initStaffSelect2();
            } else if (type == 'vendor') {
                $('#expenseVendorBlock').removeClass('d-none');
                $('#expense_vendor_id').prop('required', true);
                $('#expense_staff_id').prop('required', false).val(null).trigger('change');
                initVendorSelect2();
            } else {
                $('#expense_vendor_id').prop('required', false).val(null).trigger('change');
                $('#expense_staff_id').prop('required', false).val(null).trigger('change');
            }
        });

        // 🔹 Staff Select2 Init
        function initStaffSelect2() {

            if ($('#expense_staff_id').hasClass('select2-hidden-accessible')) {
                return;
            }

            $('#expense_staff_id').select2({
                theme: 'bootstrap-5',
                placeholder: 'Search staff by name / phone',
                allowClear: true,
                width: '100%',
                minimumInputLength: 2,
                dropdownParent: $('#expenseModal'),

                ajax: {
                    url: "{{ route('staff.search') }}",
                    dataType: 'json',
                    delay: 300,
                    data: function (params) {
                        return {
                            q: params.term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(item => ({
                                id: item.id,
                                text: `${item.name} (${item.category} - ${item.designation})`
                            }))
                        };
                    }
                }
            });
        }

        function initVendorSelect2() {

            if ($('#expense_vendor_id').hasClass('select2-hidden-accessible')) {
                return;
            }

            $('#expense_vendor_id').select2({
                theme: 'bootstrap-5',
                placeholder: 'Search vendor by name',
                allowClear: true,
                width: '100%',
                minimumInputLength: 2,
                dropdownParent: $('#expenseModal'),

                ajax: {
                    url: "{{ route('vendors.search') }}",
                    dataType: 'json',
                    delay: 300,
                    data: function (params) {
                        return {
                            q: params.term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(item => ({
                                id: item.id,
                                text: `${item.name}`
                            }))
                        };
                    }
                }
            });
        }

        // 🔹 Reset modal
        document.getElementById('expenseModal')
            .addEventListener('show.bs.modal', function () {

                const form = document.getElementById('expenseForm');
                form.reset();

                $('#expenseStaffBlock').addClass('d-none');
                $('#expenseVendorBlock').addClass('d-none');

                $('#expense_staff_id').val(null).trigger('change');
            });

    });
</script>


<script>
    $('#expenseForm').on('submit', function (e) {
        e.preventDefault();

        let formData = new FormData(this);

        $.ajax({
            url: "{{ route('transaction.expense.store') }}",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,

            beforeSend() {
                $('#expenseBtn').prop('disabled', true).text('Saving...');
            },

            success(res) {
                toastr.success(res.message);

                $('#expenseModal').modal('hide');
                $('#expenseForm')[0].reset();
                $('#staffBlock, #vendorBlock').addClass('d-none');
                $('#staff_id').val(null).trigger('change');
                $('#vendor_id').val(null).trigger('change');

                location.reload();
            },

            error(xhr) {
                if (xhr.status === 422) {
                    Object.values(xhr.responseJSON.errors)
                        .forEach(err => toastr.error(err[0]));
                } else {
                    toastr.error('Expense save failed');
                }
            },

            complete() {
                $('#expenseBtn').prop('disabled', false).text('Save Expense');
            }
        });
    });
</script>

<script>
    document.addEventListener('click', function (e) {

        const btnEl = e.target.closest('.delete-transaction');
        if (!btnEl) return;

        const $btn = $(btnEl); // ✅ jQuery object
        const url  = $btn.data('url');

        Swal.fire({
            title: 'Are you sure?',
            text: 'This transaction will be permanently deleted!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Delete',
            cancelButtonText: 'Cancel'
        }).then((result) => {

            if (!result.isConfirmed) return;

            $.ajax({
                url: url,
                type: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                beforeSend: function () {
                    $btn.prop('disabled', true);
                },
                success: function (res) {
                    $btn.prop('disabled', false);

                    if (res.status) {
                        toastr.success(res.message);
                        $btn.closest('tr').remove();
                    } else {
                        toastr.error(res.message);
                    }
                },
                error: function (xhr) {
                    Swal.fire(
                        'Error!',
                        xhr.responseJSON?.message || 'Unable to process request',
                        'error'
                    );

                    $btn.prop('disabled', false);
                }
            });
        });
    });

</script>

<script>
    const incomeUpdateUrl = "{{ route('transaction.income.update', ':id') }}";
    const expenseUpdateUrl = "{{ route('transaction.expense.update', ':id') }}";
</script>


<script>
/* ===================== EDIT BUTTON CLICK ===================== */
$(document).on('click', '.edit-transaction', function () {

    let id   = $(this).data('id');
    let type = $(this).data('type');
    let url  = $(this).data('edit-url');

    $.get(url, function (res) {

        if (type === 'income') {
            fillIncomeEdit(res);
            $('#incomeEditModal').modal('show');
        } else {
            fillExpenseEdit(res);
            $('#expenseEditModal').modal('show');
        }
    });
});


/* ===================== FILL INCOME ===================== */
function fillIncomeEdit(data) {

    $('#edit_income_id').val(data.id);
    let form = $('#incomeEditForm');

    form.find('[name=income_head_id]').val(data.income_head_id);
    form.find('[name=transaction_amount]').val(data.transaction_amount);
    form.find('[name=payment_method]').val(data.payment_method);
    form.find('[name=transaction_date]').val(data.transaction_date);
    form.find('[name=transaction_ref_id]').val(data.transaction_ref_id);
    form.find('[name=transaction_details]').val(data.transaction_details);

    $('#edit_income_source_type').val(data.source_type).trigger('change');

    if (data.source_type === 'student') {
        let s = data.student;
        let opt = new Option(`${s.admission_no} - ${s.name} (${s.class_name}-${s.section_name})`, data.source_id, true, true);
        $('#edit_income_student_id').append(opt).trigger('change');
    } else {
        form.find('[name=source_name]').val(data.source_name);
    }
}


/* ===================== FILL EXPENSE ===================== */
function fillExpenseEdit(data) {

    $('#edit_expense_id').val(data.id);
    let form = $('#expenseEditForm');

    form.find('[name=expense_head_id]').val(data.expense_head_id);
    form.find('[name=transaction_amount]').val(data.transaction_amount);
    form.find('[name=payment_method]').val(data.payment_method);
    form.find('[name=transaction_date]').val(data.transaction_date);
    form.find('[name=transaction_ref_id]').val(data.transaction_ref_id);
    form.find('[name=transaction_details]').val(data.transaction_details);

    $('#edit_expense_source_type').val(data.source_type).trigger('change');

    if (data.source_type === 'staff'&& data.source_id) {
        let opt = new Option(data.staff.name, data.source_id, true, true);
        $('#edit_expense_staff_id').append(opt).trigger('change');
    } else if (data.source_type === 'vendor' && data.source_id){
        //form.find('[name=source_name]').val(data.source_name);
        let opt = new Option(data.vendor.name, data.source_id, true, true);
        $('#edit_expense_vendor_id').append(opt).trigger('change');
    }
}


/* ===================== SOURCE TYPE TOGGLE ===================== */
$('#edit_income_source_type').on('change', function () {
    let v = $(this).val();
    $('#editIncomeStudentBlock').toggleClass('d-none', v !== 'student');
    $('#editIncomeGuestBlock').toggleClass('d-none', v === 'student');
    if(v=='student'){
        initEditStudentSelect2();
    }
});

$('#edit_expense_source_type').on('change', function () {
    let v = $(this).val();
    $('#editExpenseStaffBlock').toggleClass('d-none', v !== 'staff');
    $('#editExpenseVendorBlock').toggleClass('d-none', v !== 'vendor');
    if(v=='staff'){
        $('#edit_expense_staff_id').prop('required', true);
        $('#edit_expense_vendor_id').prop('required', false).val(null).trigger('change');
        initEditStaffSelect2();

    } else if(v=='vendor'){
        $('#edit_expense_vendor_id').prop('required', true);
        $('#edit_expense_staff_id').prop('required', false).val(null).trigger('change');
        initEditVendorSelect2();
    } else {
        $('#edit_expense_vendor_id').prop('required', false).val(null).trigger('change');
        $('#edit_expense_staff_id').prop('required', false).val(null).trigger('change');
    }
});


/* ===================== SELECT2 ===================== */

// STUDENT

function initEditStudentSelect2() {

    // destroy if already initialized
    if ($('#edit_income_student_id').hasClass('select2-hidden-accessible')) {
        $('#edit_income_student_id').select2('destroy');
    }

    $('#edit_income_student_id').select2({
        theme: 'bootstrap-5',
        dropdownParent: $('#incomeEditModal'), // 🔥 REQUIRED
        placeholder: 'Search student by name / admission no',
        allowClear: true,
        width: '100%',
        minimumInputLength: 2,
        ajax: {
            url: "{{ route('students.search') }}",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return { q: params.term };
            },
            processResults: function (data) {
                return {
                    results: data.map(s => ({
                        id: s.id,
                        text: `${s.admission_no} - ${s.name} (${s.class_name}-${s.section_name})`
                    }))
                };
            }
        }
    });
}


function initEditStaffSelect2() {

    if ($('#edit_expense_staff_id').hasClass('select2-hidden-accessible')) {
        return;
    }

    $('#edit_expense_staff_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'Search staff by name / phone',
        allowClear: true,
        width: '100%',
        minimumInputLength: 2,
        dropdownParent: $('#expenseEditModal'),

        ajax: {
            url: "{{ route('staff.search') }}",
            dataType: 'json',
            delay: 300,
            data: function (params) {
                return {
                    q: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data.map(item => ({
                        id: item.id,
                        text: `${item.name} (${item.category} - ${item.designation})`
                    }))
                };
            }
        }
    });
}

function initEditVendorSelect2() {

    if ($('#edit_expense_vendor_id').hasClass('select2-hidden-accessible')) {
        return;
    }

    $('#edit_expense_vendor_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'Search vendor by name',
        allowClear: true,
        width: '100%',
        minimumInputLength: 2,
        dropdownParent: $('#expenseEditModal'),

        ajax: {
            url: "{{ route('vendors.search') }}",
            dataType: 'json',
            delay: 300,
            data: function (params) {
                return {
                    q: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data.map(item => ({
                        id: item.id,
                        text: `${item.name}`
                    }))
                };
            }
        }
    });
}


/* ===================== SUBMIT INCOME ===================== */
$('#incomeEditForm').on('submit', function (e) {
    e.preventDefault();

    let id = $('#edit_income_id').val();
    let formData = new FormData(this);

    let url = incomeUpdateUrl.replace(':id', id);

    $.ajax({
        url: url,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,

        beforeSend() {
            $('#incomeEditBtn').prop('disabled', true).text('Updating...');
        },

        success(res) {
            toastr.success(res.message);
            $('#incomeEditModal').modal('hide');
            //location.reload();
        },

        error(xhr) {
            if (xhr.status === 422) {
                Object.values(xhr.responseJSON.errors)
                    .forEach(err => toastr.error(err[0]));
            } else {
                toastr.error('Income update failed');
            }
        },

        complete() {
            $('#incomeEditBtn').prop('disabled', false).text('Update Income');
        }
    });
});




/* ===================== SUBMIT EXPENSE ===================== */
$('#expenseEditForm').on('submit', function (e) {
    e.preventDefault();

    let id = $('#edit_expense_id').val();
    let formData = new FormData(this);

    let url = expenseUpdateUrl.replace(':id', id);

    $.ajax({
        url: url,
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,

        beforeSend() {
            $('#expenseEditBtn').prop('disabled', true).text('Updating...');
        },

        success(res) {
            toastr.success(res.message);
            $('#expenseEditModal').modal('hide');
            location.reload();
        },

        error(xhr) {
            if (xhr.status === 422) {
                Object.values(xhr.responseJSON.errors)
                    .forEach(err => toastr.error(err[0]));
            } else {
                toastr.error('Expense update failed');
            }
        },

        complete() {
            $('#expenseEditBtn').prop('disabled', false).text('Update Income');
        }
    });
});

$(document).ready(function () {

    let today = new Date();

    // Max = today (disable future)
    let maxDate = today.toISOString().split('T')[0];


    $('.trans-date').attr('max', maxDate);

});
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {

        const urlParams = new URLSearchParams(window.location.search);
        const tab = urlParams.get('type') || 'income';

        const tabMap = {
            income: 'income_history',
            expense: 'expense_history'
        };

        if (tabMap[tab]) {
            console.log(tabMap[tab]);
            const triggerEl = document.getElementById(tabMap[tab]);
            if (triggerEl) {
                new bootstrap.Tab(triggerEl).show();
            }
        }
    });
</script>
<script>
    document.querySelectorAll('[data-bs-toggle="tab"]').forEach(tab => {

        tab.addEventListener('shown.bs.tab', function () {

            const type = this.dataset.type;

            const newUrl =
                window.location.origin +
                window.location.pathname +
                '?type=' + type;

            const params = new URLSearchParams(window.location.search);
            const route = params.get('type');
            // Change URL without reload
            if(( route == 'expense' && type == 'income') || (route == 'income' && type == 'expense') || (route == null) ){
                window.history.pushState({}, '', newUrl);
            } 
                
        });

    });
</script>



@endsection

