<?php $__env->startSection('title','Transaction Config'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Transaction Configuration</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="fees-page" class="page-content">
    <h1 class="mb-4">Transaction Configuration</h1>
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="income_head" data-bs-toggle="tab" data-bs-target="#income-head" type="button" role="tab">Income Head</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link " id="expense_head" data-bs-toggle="tab" data-bs-target="#expense-head" type="button" role="tab">Expense Head</button>
        </li>
    </ul>

    <div class="tab-content">

        <div class="tab-pane fade show active" id="income-head" role="tabpanel">
            <?php echo $__env->make('transaction_config.income', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <!-- Fee Configuration Tab -->
        <div class="tab-pane fade" id="expense-head" role="tabpanel">
            <?php echo $__env->make('transaction_config.expense', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

    <div class="modal fade" id="editIncomeHeadModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editIncomeHeadForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <input type="hidden" id="edit_id">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Income Head</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <div class="mb-3">
                            <label class="form-label">Head Name *</label>
                            <input type="text" class="form-control" id="edit_name" name="name">
                            <small class="text-danger d-none" id="error_name"></small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" id="edit_description" name="description"></textarea>
                            <small class="text-danger d-none" id="error_description"></small>
                        </div>

                    </div>


                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="saveBtn">
                            <span id="saveText">Update</span>
                            <span id="saveSpinner" class="spinner-border spinner-border-sm d-none"></span>
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="editExpenseHeadModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editExpenseHeadForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <input type="hidden" id="expense_edit_id">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Expense Head</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <div class="mb-3">
                            <label class="form-label">Head Name *</label>
                            <input type="text" class="form-control" id="expense_edit_name" name="name">
                            <small class="text-danger d-none" id="expense_error_name"></small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" id="expense_edit_description" name="description"></textarea>
                            <small class="text-danger d-none" id="expense_error_description"></small>
                        </div>

                    </div>


                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="saveBtnExpense">
                            <span id="saveTextExpense">Update</span>
                            <span id="saveSpinnerExpense" class="spinner-border spinner-border-sm d-none"></span>
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>

                </div>
            </form>
        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $(document).on('change', '.income-status', function () {
                let checkbox = $(this);
                let fee_status = checkbox.prop('checked') ? 1 : 0;

                $.ajax({
                    url: checkbox.data('url'),
                    type: "PUT",             
                    //dataType: "json",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",    
                        status: fee_status
                    },
                    success: function (data) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: data.message
                        });
                    },
                    error: function (xhr) {
                        let message = 'Status not updated';

                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: message
                        });

                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });
            });

        });

    </script>
    <script>
        document.addEventListener('click', function (e) {
            if (!e.target.classList.contains('deleteIncomeHeadBtn')) return;

            const url = e.target.dataset.url;
            const row = e.target.closest('tr');

            Swal.fire({
                title: "Are you sure?",
                text: "This Income head will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
            }).then(result => {
                if (!result.isConfirmed) return;

                fetch(url, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        row.remove();
                        Swal.fire('Deleted!', res.message, 'success');
                    } else {
                        Swal.fire('Error!', res.message, 'error');
                    }
                });
            });
        });

    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {

            let editModal = new bootstrap.Modal(
                document.getElementById('editIncomeHeadModal')
            );

            const saveBtn = document.getElementById('saveBtn');
            const saveText = document.getElementById('saveText');
            const saveSpinner = document.getElementById('saveSpinner');

            function resetErrors() {
                document.querySelectorAll('[id^="error_"]').forEach(el => {
                    el.classList.add('d-none');
                    el.innerText = '';
                });
            }

            function toggleLoading(state) {
                saveBtn.disabled = state;
                saveSpinner.classList.toggle('d-none', !state);
                saveText.classList.toggle('d-none', state);
            }

            // Open modal
            document.querySelectorAll('.edit-income-head').forEach(btn => {
                btn.addEventListener('click', function () {

                    resetErrors();

                    document.getElementById('edit_id').value = this.dataset.id;
                    document.getElementById('edit_name').value = this.dataset.name;
                    document.getElementById('edit_description').value = this.dataset.description;

                    editModal.show();
                });
            });

            // AJAX Save
            document.getElementById('editIncomeHeadForm').addEventListener('submit', function (e) {
                e.preventDefault();

                resetErrors();
                toggleLoading(true);

                let id = document.getElementById('edit_id').value;

                fetch("<?php echo e(url('transaction_config/income-head')); ?>/" + id, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'X-HTTP-Method-Override': 'PUT',
                        'Accept': 'application/json'
                    },
                    body: new FormData(this)
                })
                .then(async res => {
                    toggleLoading(false);

                    if (!res.ok) {
                        let data = await res.json();
                        throw data;
                    }
                    return res.json();
                })
                .then(data => {

                    Swal.fire({
                        icon: 'success',
                        title: 'Updated',
                        text: data.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    const newName = document.getElementById('edit_name').value;
                    const newDescription = document.getElementById('edit_description').value;

                    // Find edit button
                    let editBtn = document.querySelector(
                        `.edit-income-head[data-id="${id}"]`
                    );

                    // Update table row text
                    let row = editBtn.closest('tr');
                    row.children[0].innerText = newName;
                    row.children[1].innerText = newDescription;

                    //  Update data attributes (IMPORTANT)
                    editBtn.dataset.name = newName;
                    editBtn.dataset.description = newDescription;

                    editModal.hide();
                })

                .catch(err => {
                    toggleLoading(false);

                    if (err.errors) {
                        Object.keys(err.errors).forEach(field => {
                            let errorEl = document.getElementById('error_' + field);
                            if (errorEl) {
                                errorEl.innerText = err.errors[field][0];
                                errorEl.classList.remove('d-none');
                            }
                        });
                    } else if (err.message) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: err.message
                        });
                    }
                });
            });

        });
    </script>



<script>
    $(document).ready(function() {
        $(document).on('change', '.expense-status', function () {
            let checkbox = $(this);
            let fee_status = checkbox.prop('checked') ? 1 : 0;

            $.ajax({
                url: checkbox.data('url'),
                type: "PUT",             
                //dataType: "json",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",    
                    status: fee_status
                },
                success: function (data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function (xhr) {
                    let message = 'Status not updated';

                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: message
                    });

                    checkbox.prop('checked', !checkbox.prop('checked'));
                }
            });
        });

    });

</script>
<script>
    document.addEventListener('click', function (e) {
        if (!e.target.classList.contains('deleteExpenseHeadBtn')) return;

        const url = e.target.dataset.url;
        const row = e.target.closest('tr');

        Swal.fire({
            title: "Are you sure?",
            text: "This Expense head will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#e3342f",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it",
            cancelButtonText: "Cancel",
        }).then(result => {
            if (!result.isConfirmed) return;

            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(res => res.json())
            .then(res => {
                if (res.success) {
                    row.remove();
                    Swal.fire('Deleted!', res.message, 'success');
                } else {
                    Swal.fire('Error!', res.message, 'error');
                }
            });
        });
    });

</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {

        let editModal = new bootstrap.Modal(
            document.getElementById('editExpenseHeadModal')
        );

        const saveBtn = document.getElementById('saveBtnExpense');
        const saveText = document.getElementById('saveTextExpense');
        const saveSpinner = document.getElementById('saveSpinnerExpense');

        function resetErrors() {
            document.querySelectorAll('[id^="expense_error_"]').forEach(el => {
                el.classList.add('d-none');
                el.innerText = '';
            });
        }

        function toggleLoading(state) {
            saveBtn.disabled = state;
            saveSpinner.classList.toggle('d-none', !state);
            saveText.classList.toggle('d-none', state);
        }

        // Open modal
        document.querySelectorAll('.edit-expense-head').forEach(btn => {
            btn.addEventListener('click', function () {

                resetErrors();

                document.getElementById('expense_edit_id').value = this.dataset.id;
                document.getElementById('expense_edit_name').value = this.dataset.name;
                document.getElementById('expense_edit_description').value = this.dataset.description;

                editModal.show();
            });
        });

        // AJAX Save
        document.getElementById('editExpenseHeadForm').addEventListener('submit', function (e) {
            e.preventDefault();

            resetErrors();
            toggleLoading(true);

            let id = document.getElementById('expense_edit_id').value;

            fetch("<?php echo e(url('transaction_config/expense-head')); ?>/" + id, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'X-HTTP-Method-Override': 'PUT',
                    'Accept': 'application/json'
                },
                body: new FormData(this)
            })
            .then(async res => {
                toggleLoading(false);

                if (!res.ok) {
                    let data = await res.json();
                    throw data;
                }
                return res.json();
            })
            .then(data => {

                Swal.fire({
                    icon: 'success',
                    title: 'Updated',
                    text: data.message,
                    timer: 1500,
                    showConfirmButton: false
                });

                const newName = document.getElementById('expense_edit_name').value;
                const newDescription = document.getElementById('expense_edit_description').value;

                // Find edit button
                let editBtn = document.querySelector(
                    `.edit-expense-head[data-id="${id}"]`
                );

                // Update table row text
                let row = editBtn.closest('tr');
                row.children[0].innerText = newName;
                row.children[1].innerText = newDescription;

                //  Update data attributes (IMPORTANT)
                editBtn.dataset.name = newName;
                editBtn.dataset.description = newDescription;

                editModal.hide();
            })

            .catch(err => {
                toggleLoading(false);

                if (err.errors) {
                    Object.keys(err.errors).forEach(field => {
                        let errorEl = document.getElementById('expense_error_' + field);
                        if (errorEl) {
                            errorEl.innerText = err.errors[field][0];
                            errorEl.classList.remove('d-none');
                        }
                    });
                } else if (err.message) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: err.message
                    });
                }
            });
        });

    });
</script>


    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const urlParams = new URLSearchParams(window.location.search);
            const tab = urlParams.get('tab') || 'list';

            const tabMap = {
                income_head: 'income_head',
                expense_head: 'expense_head'
            };

            if (tabMap[tab]) {
                console.log(tabMap[tab]);
                const triggerEl = document.getElementById(tabMap[tab]);
                if (triggerEl) {
                    new bootstrap.Tab(triggerEl).show();
                }
            }
        });
    </script>




<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/transaction_config/index.blade.php ENDPATH**/ ?>