

<?php $__env->startSection('title','Expense Ledger'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item">
    <a href="<?php echo e(route('ledgers.index')); ?>">Ledger</a>
</li>
<li class="breadcrumb-item active">Expense Ledger</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <div class="card mb-4">
        <div class="card-header bg-light">
            <div class="row align-items-center">
                <div class="d-flex gap-2">
                    <div class="col">
                        <h5 class="mb-0"><?php echo e($head->name); ?></h5>
                    </div>

                </div>
            </div>
        </div>

        <div class="card-body">
            <form method="GET" class="search-form">
                <div class="row mb-3">

                    <div class="col-md-4">
                        <!-- <label>From Date</label> -->
                        <input type="date" name="from_date" value="<?php echo e(request('from_date')); ?>" class="form-control">
                    </div>
                    
                    <div class="col-md-4">
                        <!-- <label>To Date</label> -->
                        <input type="date" name="to_date" value="<?php echo e(request('to_date')); ?>" class="form-control">
                    </div>

                    <div class="col-md-4">
                        <button type="submit" class="btn btn-primary">
                            Filter
                        </button>

                        <a href="<?php echo e(route('ledger.expense.head', $head->id)); ?>"
                        class="btn btn-outline-secondary">
                            Clear Filter
                        </a>
                    </div>
                </div>
            </form>
            
            <?php $grandTotal = 0; ?>
            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-4">
                    <div class="card-header bg-secondary text-white fw-semibold">
                        <?php echo e(ucfirst($method)); ?> Payments
                    </div>

                    <div class="card-body p-0">
                        <table class="table table-bordered table-sm mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Narration</th>
                                    <th class="text-end">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $groupTotal = 0; ?>

                                <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $groupTotal += $t->transaction_amount; ?>
                                    <tr>
                                        <td><?php echo e(\Carbon\Carbon::parse($t->transaction_date)->format('d M Y')); ?></td>
                                        <td><?php echo e($t->transaction_details ?? '-'); ?></td>
                                        <td class="text-end">
                                            <?php echo e(number_format($t->transaction_amount, 2)); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <tr class="table-light fw-bold">
                                    <td colspan="2" class="text-end">Total</td>
                                    <td class="text-end">
                                        <?php echo e(number_format($groupTotal, 2)); ?>

                                    </td>
                                </tr>
                                <?php $grandTotal += $groupTotal; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <table class="table table-bordered table-sm mb-0">
                <tbody>
                    <tr class="table-light fw-bold">
                        <td colspan="2" class="text-end">Grand Total</td>
                        <td class="text-end">
                            <span class="text-danger fw-bold">
                                ₹<?php echo e(number_format($grandTotal, 2)); ?>

                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/ledgers/expense-head-ledger.blade.php ENDPATH**/ ?>