<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Add New Income Head</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('transaction_config.storeIncomeHead')); ?>">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-5">
                    <input type="text" name="name" class="form-control" placeholder="Head Name" required>
                </div>
                <div class="col-md-5">
                    <input type="text" name="description" class="form-control" placeholder="Description" required>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary w-100">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Income Heads List</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>Head Name</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($fee->name); ?></td>
                        <td><?php echo e($fee->description); ?></td>
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input income-status"
                                    type="checkbox"
                                    id="status_<?php echo e($fee->id); ?>"
                                    data-id="<?php echo e($fee->id); ?>"
                                    data-url="<?php echo e(route('transaction_config.updateIncomeHead', $fee->id)); ?>"
                                    <?php echo e($fee->status ? 'checked' : ''); ?> <?php echo e($fee->id == 1 ? 'disabled' : ''); ?>

                                >
                            </div>
                        </td>
                        <td>
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-primary edit-income-head"
                                data-id="<?php echo e($fee->id); ?>"
                                data-name="<?php echo e($fee->name); ?>"
                                data-description="<?php echo e($fee->description); ?>"
                            >
                                Edit
                            </button>
                            <?php if($fee->id != 1): ?>
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-danger deleteIncomeHeadBtn"
                                data-url="<?php echo e(route('transaction_config.deleteIncomeHead', $fee->id)); ?>"
                            >
                                Delete
                            </button>
                            <?php endif; ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No head found!
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-end mt-3">
            <?php echo e($incomeHeads->appends(['tab' => $tab])->links()); ?>

        </div>
    </div>
</div>

<?php /**PATH /var/www/html/school-ramkrishna/resources/views/transaction_config/income.blade.php ENDPATH**/ ?>