<?php $__env->startSection('title','Vendors'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Vendors</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="vendor-page" class="page-content">
    <h1 class="mb-4">Vendors</h1>
    <div class="card mb-4">
        <div class="card-header bg-light">
            <h5 class="mb-0">Add New Vendor</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('vendors.storeVendor')); ?>">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-md-5">
                        <input type="text" name="name" class="form-control" placeholder="Vendor Name" required>
                    </div>
                    <div class="col-md-5">
                        <input type="text" name="description" class="form-control" placeholder="Description" required>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-primary w-100">Add</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-light">
            <h5 class="mb-0">Vendor List</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($vendor->name); ?></td>
                            <td title="<?php echo e($vendor->description); ?>"><?php echo e(\Illuminate\Support\Str::words($vendor->description ?? '', 10, '...')); ?></td>

                            <td>
                                <div class="form-check form-switch">
                                    <input
                                        class="form-check-input vendor-status"
                                        type="checkbox"
                                        id="status_<?php echo e($vendor->id); ?>"
                                        data-id="<?php echo e($vendor->id); ?>"
                                        data-url="<?php echo e(route('vendors.updateVendor', $vendor->id)); ?>"
                                        <?php echo e($vendor->status ? 'checked' : ''); ?>

                                    >
                                </div>
                            </td>
                            <td>
                                <button
                                    type="button"
                                    class="btn btn-sm btn-outline-primary edit-vendor"
                                    data-id="<?php echo e($vendor->id); ?>"
                                    data-name="<?php echo e($vendor->name); ?>"
                                    data-description="<?php echo e($vendor->description); ?>"
                                >
                                    Edit
                                </button>

                                <button
                                    type="button"
                                    class="btn btn-sm btn-outline-danger deleteVendorBtn"
                                    data-url="<?php echo e(route('vendors.deleteVendor', $vendor->id)); ?>"
                                >
                                    Delete
                                </button>


                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted">
                                    No vendor found!
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-end mt-3">
                <?php echo e($vendors->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

    <div class="modal fade" id="editVendorModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editVendorForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <input type="hidden" id="edit_id">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Vendor</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <div class="mb-3">
                            <label class="form-label">Vendor Name *</label>
                            <input type="text" class="form-control" id="edit_name" name="name">
                            <small class="text-danger d-none" id="error_name"></small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" id="edit_description" name="description"></textarea>
                            <small class="text-danger d-none" id="error_description"></small>
                        </div>

                    </div>


                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="saveBtn">
                            <span id="saveText">Update</span>
                            <span id="saveSpinner" class="spinner-border spinner-border-sm d-none"></span>
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>

                </div>
            </form>
        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $(document).on('change', '.vendor-status', function () {
                let checkbox = $(this);
                let vendor_status = checkbox.prop('checked') ? 1 : 0;

                $.ajax({
                    url: checkbox.data('url'),
                    type: "PUT",             
                    //dataType: "json",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",    
                        status: vendor_status
                    },
                    success: function (data) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: data.message
                        });
                    },
                    error: function (xhr) {
                        let message = 'Status not updated';

                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: message
                        });

                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });
            });

        });

    </script>
    <script>
        document.addEventListener('click', function (e) {
            if (!e.target.classList.contains('deleteVendorBtn')) return;

            const url = e.target.dataset.url;
            const row = e.target.closest('tr');

            Swal.fire({
                title: "Are you sure?",
                text: "This Vendor will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
            }).then(result => {
                if (!result.isConfirmed) return;

                fetch(url, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        row.remove();
                        Swal.fire('Deleted!', res.message, 'success');
                    } else {
                        Swal.fire('Error!', res.message, 'error');
                    }
                });
            });
        });

    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {

            let editModal = new bootstrap.Modal(
                document.getElementById('editVendorModal')
            );

            const saveBtn = document.getElementById('saveBtn');
            const saveText = document.getElementById('saveText');
            const saveSpinner = document.getElementById('saveSpinner');

            function resetErrors() {
                document.querySelectorAll('[id^="error_"]').forEach(el => {
                    el.classList.add('d-none');
                    el.innerText = '';
                });
            }

            function toggleLoading(state) {
                saveBtn.disabled = state;
                saveSpinner.classList.toggle('d-none', !state);
                saveText.classList.toggle('d-none', state);
            }

            // Open modal
            document.querySelectorAll('.edit-vendor').forEach(btn => {
                btn.addEventListener('click', function () {

                    resetErrors();

                    document.getElementById('edit_id').value = this.dataset.id;
                    document.getElementById('edit_name').value = this.dataset.name;
                    document.getElementById('edit_description').value = this.dataset.description;

                    editModal.show();
                });
            });

            // AJAX Save
            document.getElementById('editVendorForm').addEventListener('submit', function (e) {
                e.preventDefault();

                resetErrors();
                toggleLoading(true);

                let id = document.getElementById('edit_id').value;

                fetch("<?php echo e(url('vendors/vendor')); ?>/" + id, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'X-HTTP-Method-Override': 'PUT',
                        'Accept': 'application/json'
                    },
                    body: new FormData(this)
                })
                .then(async res => {
                    toggleLoading(false);

                    if (!res.ok) {
                        let data = await res.json();
                        throw data;
                    }
                    return res.json();
                })
                .then(data => {

                    Swal.fire({
                        icon: 'success',
                        title: 'Updated',
                        text: data.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    const newName = document.getElementById('edit_name').value;
                    const newDescription = document.getElementById('edit_description').value;

                    // Find edit button
                    let editBtn = document.querySelector(
                        `.edit-vendor[data-id="${id}"]`
                    );

                    // Update table row text
                    let row = editBtn.closest('tr');
                    row.children[0].innerText = newName;
                    row.children[1].innerText = newDescription;

                    //  Update data attributes (IMPORTANT)
                    editBtn.dataset.name = newName;
                    editBtn.dataset.description = newDescription;

                    editModal.hide();
                })

                .catch(err => {
                    toggleLoading(false);

                    if (err.errors) {
                        Object.keys(err.errors).forEach(field => {
                            let errorEl = document.getElementById('error_' + field);
                            if (errorEl) {
                                errorEl.innerText = err.errors[field][0];
                                errorEl.classList.remove('d-none');
                            }
                        });
                    } else if (err.message) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: err.message
                        });
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/vendor/index.blade.php ENDPATH**/ ?>